from sandbox import sdk2
from sandbox.projects.Haas.common import constants


with sdk2.parameters.Group('Eine API specification') as eine_api:
    eine_api_url = sdk2.parameters.String(
        'Eine api url',
        default=constants.DefaultAPIValues.eine_api,
        required=True,
    )

    eine_token_name = sdk2.parameters.String(
        'Eine token name to get from Vault',
        default=constants.DefaultAPIValues.eine_token_name,
        required=True,
    )

    eine_token_owner = sdk2.parameters.String(
        'Eine token owner',
        default=constants.DefaultAPIValues.haas_token_owner,
        required=True,
    )


with sdk2.parameters.Group('Setup API specification') as setup_api:
    setup_api_url = sdk2.parameters.String(
        'Setup api url',
        default=constants.DefaultAPIValues.setup_api,
        required=True,
    )

    setup_token_name = sdk2.parameters.String(
        'Setup token name to get from Vault',
        default=constants.DefaultAPIValues.setup_token_name,
        required=True,
    )

    setup_token_owner = sdk2.parameters.String(
        'Setup token owner',
        default=constants.DefaultAPIValues.haas_token_owner,
        required=True,
    )


with sdk2.parameters.Group('HaaS core API specification') as haas_core_api:
    haas_core_api_url = sdk2.parameters.String(
        'HaaS core api url',
        default=constants.DefaultAPIValues.core_api,
        required=True,
    )

    haas_core_token_name = sdk2.parameters.String(
        'HaaS core token name to get from Vault',
        default=constants.DefaultAPIValues.haas_core_token_name,
        required=True,
    )

    haas_core_token_owner = sdk2.parameters.String(
        'HaaS core token owner',
        default=constants.DefaultAPIValues.haas_token_owner,
        required=True,
    )


with sdk2.parameters.String('Eine host filter', required=True) as host_filter:
    host_filter.values.hostname = host_filter.Value(constants.EineHostFilters.hostname)
    host_filter.values.inventory = host_filter.Value(
        constants.EineHostFilters.inventory,
        default=True,
    )


status_update_period = sdk2.parameters.Integer(
    'Status update period (seconds)',
    default=30,
    required=True,
)


def get_operations_timeout(seconds):
    operations_timeout = sdk2.parameters.Integer(
        'Operations timeout (seconds)',
        default=seconds,
        required=True,
    )
    return operations_timeout
