# -*- coding: utf-8 -*-
import datetime as dt
import logging
from sandbox import sdk2
from sandbox.sandboxsdk import environments


DATE_REGEXP = '[0-9]{4}-[0-9]{2}-[0-9]{2}'
DATE_FORMAT = '%Y-%m-%d'
YESTERDAY = (dt.date.today() - dt.timedelta(days=1)).strftime(DATE_FORMAT)
DEFAULT_YT_PREFIX = '//home/haas/walle_projects'
DEFAULT_YT_TOKEN_VAULT_NAME = 'YT_TOKEN'


class HaasCmisExportWalleProjectsToYt(sdk2.Task):
    """ Run me to export Wall-e hosts-projects snapshot to YT. """

    class Requirements(sdk2.Task.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings')
        ]

    class Parameters(sdk2.Parameters):
        yt_prefix = sdk2.parameters.String('YT directory to save yyyy-mm-dd table', required=True,
                                           default=DEFAULT_YT_PREFIX)
        yt_token_vault_name = sdk2.parameters.String('YT Token secret name', required=True,
                                                     default=DEFAULT_YT_TOKEN_VAULT_NAME)

    def on_execute(self):
        logging.info('Hello, Sandbox!')
