from sandbox import sdk2
import logging


class HelloPrimeTask(sdk2.Task):
    """Task that prints divisors of time()"""

    class Parameters(sdk2.Task.Parameters):
        n = sdk2.parameters.Integer("Number to check", required=True)
        dc = sdk2.parameters.Dict("Testting dict")

    class Context(sdk2.Task.Context):
        is_prime = None

    def on_execute(self):
        di = 2
        n = self.Parameters.n
        once = False
        while di * di <= n:
            if n % di == 0:
                logging.info(str(di))
                logging.info(str(n / di))
                once = True
            di += 1
        if not once:
            logging.info("Time is prime")
            self.Context.is_prime = True
        else:
            self.Context.is_prime = False
