from sandbox import sdk2
import requests
import logging


class UploadGencfgTopology(sdk2.Task):
    """
    Sandbox task to upload given gencfg topology to s3 storage
    """

    class Parameters(sdk2.Parameters):

        s3_host = sdk2.parameters.String('S3 Host', default_value='s3.mdst.yandex.net', required=True)

    def on_execute(self):

        r = requests.get('http://{}/gencfg-releases-000/w-generated/golovan.tags'.format(self.Parameters.s3_host))
        logging.info('HTTP_CODE:{}'.format(r.status_code))
        logging.info('TEXT:{}'.format(r.text))
