# -*- coding: utf-8 -*-

import logging
import json
from sandbox import sdk2
from sandbox.projects.HttpGeobase.qloud import HttpGeobaseQloudAPI
from sandbox.common.utils import singleton_property
from sandbox.projects.sandbox_ci.utils.request import send_request


class UpdateHttpGeobaseTask(sdk2.Task):
    @singleton_property
    def qloud_api(self):
        return HttpGeobaseQloudAPI()

    class Parameters(sdk2.Task.Parameters):
        qloud_environment_id = sdk2.parameters.String('qloud environment id')

    def on_execute(self):
            environment = self.qloud_api.get_env_dump(self.Parameters.qloud_environment_id)

            url = 'https://sandbox.yandex-team.ru/api/v1.0/resource?limit=1&offset=0&order=-time&id=&type=GEODATA6BIN_STABLE&state=READY'
            logging.info('Getting latest geobase resource id')
            res = send_request('get', url, verify=False)
            res.raise_for_status()

            geodata = json.loads(res.text)
            new_id = geodata['items'][0]['id']
            logging.info('New id is {}'.format(new_id))

            environment['comment'] = 'Auto update geodata6.bin to {} resource'.format(new_id)

            something_to_update = False

            for component in environment["components"]:
                for resource in component["sandboxResources"]:
                    if resource["localName"] == "geodata6.bin" and resource["id"] != new_id:
                        resource["id"] = new_id
                        something_to_update = True

            if something_to_update:
                self.qloud_api.upload_environment(environment)
