# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.sandbox_ci.qloud import QloudApi
import logging
import json

from sandbox.projects.sandbox_ci.utils.request import send_request


class HttpGeobaseQloudAPI(QloudApi):
    def __init__(self):
        super(HttpGeobaseQloudAPI, self).__init__(token=sdk2.Vault.data('HTTP_GEOBASE_QLOUD_TOKEN'), url="https://qloud-ext.yandex-team.ru")

    def get_env_dump(self, environment_id):
        self.check_not_readonly()

        url = self.get_full_url('api/v1/environment/dump/{}'.format(environment_id))
        logging.info('Getting qloud environment domain {}'.format(environment_id))

        res = send_request('get', url, headers=self._headers, verify=False)
        res.raise_for_status()

        return json.loads(res.text)

    def upload_env_dump(self, dump):
        self.check_not_readonly()

        url = self.get_full_url('api/v1/environment/upload/return_headers?targetState=DEPLOYED&skipIfNoChange=true')
        logging.info('Uploading qloud environment')

        res = send_request('post', url, headers=self._headers, verify=False, data=dump)
        res.raise_for_status()

        return json.loads(res.text)
