# -*- coding: utf-8 -*-

import logging
import time

import sandbox.sandboxsdk.task as sdk_task
from sandbox.sandboxsdk import environments


class Task(sdk_task.SandboxTask):

    type = "ISS_CRUTCH"
    environment = (environments.PipEnvironment(
        'cassandra-driver', '3.7.0', use_wheel=True),)

    def on_execute(self):

        from cassandra.cluster import Cluster
        from cassandra import ConsistencyLevel

        logging.info("ISS crutch started at {}".format(time.time()))
        cluster = Cluster(['iss00-prestable.search.yandex.net',
                           'iss01-prestable.search.yandex.net'])
        session = cluster.connect('iss')
        config_lookup_stmt = session.prepare('SELECT host, service, states FROM target_state',
                                             consistency_level=ConsistencyLevel.LOCAL_QUORUM)
        delete_stmt = session.prepare(
            'DELETE states[?] FROM target_state WHERE host = ? AND service = ?')
        rows = session.execute(config_lookup_stmt)
        checked = 0
        removed = 0
        innone = 0
        for row in rows:
            if row.states is not None:
                for configuration, state in row.states.items():
                    checked += 1
                    if "REMOVED" in state:
                        changed_at = time.strptime(state.split('=.', 1)[0][
                                                   :19], '%Y-%m-%dT%H:%M:%S')
                        # time passed in hours
                        passed = (time.time() - time.mktime(changed_at)) / 3600
                        logging.info("Found REMOVED at {}, passed till now {}".format(
                            changed_at, passed))
                        if passed >= 6:
                            logging.critical('Remove {} from {}:{}'.format(
                                configuration, row.host, row.service))
                            session.execute(
                                delete_stmt, (configuration, row.host, row.service))
                            removed += 1
                        elif passed >= 3:
                            logging.warning('Old configuration {} from {}:{}'.format(
                                configuration, row.host, row.service))
                    else:
                        checked += 1
                        innone += 1
        logging.info('{} configurations checked, {} removed, in state None {}'.format(
            checked, removed, innone))
