# -*- coding: utf-8 -*-

import json
from os import listdir

import sandbox.common.types.client as ctc

from sandbox.projects import resource_types
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.environments import SvnEnvironment
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk import process

from sandbox.projects.IexUtil import TESTS, DOCS_EXT
from sandbox.projects.PSUtil import calculate_diff, create_file_with_content


class IexCompareFuncTestResults(SandboxTask):
    type = 'IEX_COMPARE_FUNC_TEST_RESULTS'
    execution_space = 1000
    environment = (SvnEnvironment(), )
    client_tags = ctc.Tag.LINUX_PRECISE

    class OldAnsResourceId(parameters.ResourceSelector):
        required = True
        name = 'old_ans_resource_id'
        description = 'Old answers'
        resource_type = resource_types.IEX_FUNC_TEST_RESULT

    class NewAnsResourceId(parameters.ResourceSelector):
        required = True
        name = 'new_ans_resource_id'
        description = 'New answers'
        resource_type = resource_types.IEX_FUNC_TEST_RESULT

    input_parameters = [OldAnsResourceId, NewAnsResourceId] + TESTS

    def __init__(self, task_id=0):
        SandboxTask.__init__(self, task_id)

    def on_execute(self):
        import sys
        reload(sys)
        sys.setdefaultencoding("utf-8")

        diff_dir = self.abs_path('diff')
        make_folder(diff_dir)

        old_answers_path = self.sync_resource(self.ctx['old_ans_resource_id'])
        new_answers_path = self.sync_resource(self.ctx['new_ans_resource_id'])

        list_of_entities_with_changes = []
        entities = listdir(new_answers_path)
        for e in entities:
            tests_url = (channel.sandbox.get_resource(self.ctx[e + '_tests_resource_id'])).url
            diff_path = diff_dir + '/' + e + '.diffs.html'
            create_file_with_content(diff_path, '<head><meta charset="UTF-8"></head>\n')
            fails_diff_path = diff_dir + '/' + e + '.only_diffs.html'
            create_file_with_content(fails_diff_path, '<head><meta charset="UTF-8"></head>\n')

            tests_dir = self.sync_resource(self.ctx[e + '_tests_resource_id'])
            tests_info = json.loads(open(tests_dir + '/tests_data.json').read())
            has_diffs = False
            for test_info in tests_info:
                id_str = str(test_info['id'])
                new_answer_path = new_answers_path + '/' + e + '/' + id_str + '.txt'
                old_answer_path = old_answers_path + '/' + e + '/' + id_str + '.txt'
                log = '<b>%s::<a target="_blank" href="%s/doc/%s.{}">Doc</a>::%s</b>' % (id_str, tests_url, '' + id_str + '.' + DOCS_EXT[e], test_info['query'])
                c = calculate_diff(log, e, old_answer_path, new_answer_path, diff_path, fails_diff_path, True)
                has_diffs = has_diffs or c

            if has_diffs:
                list_of_entities_with_changes += [e]
                process.run_process(['mv', diff_path, diff_dir + '/!' + e + '.diffs.html'])
                process.run_process(['mv', fails_diff_path, diff_dir + '/!' + e + '.only_diffs.html'])

        self.create_resource(
            description=self.descr,
            resource_type=resource_types.IEX_DIFF_FUNC_RESULTS,
            resource_path=diff_dir,
            attributes={'ttl': 100, 'backup_task': True, 'entity': ','.join(entities)}
        )

        self.ctx['has_diff'] = json.dumps(list_of_entities_with_changes)
        self.set_info('Diff exists: {}'.format(self.ctx['has_diff']))


__Task__ = IexCompareFuncTestResults
