# -*- coding: utf-8 -*-

import logging
import os

from sandbox.common.types.client import Tag

from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.errors import SandboxSubprocessError
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.task import SandboxTask

from sandbox.projects.PSUtil import read_text, generate_log_str


def download_text(url, filename):
    os.system('telnet mbo-robot-ui.http.yandex.net 34802 > telnet.log 2>&1')
    logging.info(read_text('telnet.log'))
    os.system('wget ' + url)
    if os.path.exists('config'):
        run_process(['mv', 'config', filename], wait=True, check=True, log_prefix='mv_config')
    else:
        SandboxSubprocessError('<font color="red">ERROR! File "config" does not exist</font><br>Вероятней всего у '
                               'этой машины сендбокса нет нужной дырки. Скопируйте этот таск и запустите его на другой '
                               'машине. На машинах "sandbox\d\d\d" должно работать.')


class IexImportPatterns(SandboxTask):
    type = 'IEX_IMPORT_PATTERNS'

    client_tags = Tag.LINUX_PRECISE

    class Path2Config(parameters.SandboxStringParameter):
        name = 'path_to_config'
        description = 'Path to config'
        # 'http://mbo.market.yandex.ru/robot/export/config'
        default_value = 'https://mbo-robot-ui.http.yandex.net:34817/robot/export/config'

    input_parameters = [Path2Config]

    def on_execute(self):
        config_path = os.path.join(self.abs_path(), 'xml-patterns.json')
        download_text(self.ctx['path_to_config'], config_path)
        config_size = os.path.getsize(config_path)/1000000.0
        self.create_resource(description=self.descr, resource_path=config_path, resource_type='MARKET_CONFIG',
                             attributes={'patterns': 'yes'})
        is_small = config_size < 3.5
        log_info = [('config_size(MB)', config_size, is_small)]
        log_str = generate_log_str(log_info)
        if is_small:
            raise SandboxSubprocessError(log_str)
        self.set_info(log_str, do_escape=False)


__Task__ = IexImportPatterns
