#!/usr/bin/env python
# -*- coding: utf-8 -*-
import itertools as it
from copy import deepcopy

import sandbox.common.types.client as ctc
from sandbox.common.types.task import TaskStatus
from sandbox.projects.common.apihelpers import get_last_resource_with_attrs, list_task_resources
from sandbox.projects.common.FuncTestSuiteBase import FuncTestSuiteBase
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.environments import SvnEnvironment

from sandbox.projects.IexBuildPackages import IexBuildPackages
from sandbox.projects.IexUtil import SHOOTS, TESTS, LOAD_COMMON_SETTINGS, LOAD_SHOOTS_SETTINGS
from sandbox.projects.PSUtil import yassert


class IexPrepareRelease(FuncTestSuiteBase):
    type = 'IEX_PREPARE_RELEASE'
    execution_space = 5000
    environment = (SvnEnvironment(), )

    class TestRun(parameters.SandboxBoolParameter):
        name = 'test_run'
        description = (
            'Protestirovat, chto server zapuskaetsch so vsemi konfigami '
            '(func/load/dump/prod) i otvechaet na ping'
        )
        default_value = True

    class TestFunc(parameters.SandboxBoolParameter):
        name = 'test_func'
        default_value = True
        description = 'Protestirovat funktsionalno'
        sub_fields = {'true': [_.name for _ in TESTS]}

    class TestLoad(parameters.SandboxBoolParameter):
        name = 'test_load'
        default_value = True
        description = 'Protestirovat nagruzochno'
        sub_fields = {'true': [_.name for _ in it.chain(LOAD_COMMON_SETTINGS, LOAD_SHOOTS_SETTINGS)]}

    input_parameters = (
        IexBuildPackages.input_parameters +
        [TestRun, TestFunc] + TESTS +
        [TestLoad] + LOAD_COMMON_SETTINGS + LOAD_SHOOTS_SETTINGS
    )
    client_tags = ctc.Tag.LINUX_PRECISE

    def __init__(self, task_id=0):
        FuncTestSuiteBase.__init__(self, task_id)
        self.log_info = {}

    @staticmethod
    def get_package_descr(p):
        return p.attributes['package'] + ' 0.' + str(p.attributes['version']) \
            + ' (<a href="{0}">resource</a>, <a href="{1}">task</a>)'\
            .format(p.url, channel.sandbox.get_task(p.task_id).url)

    def on_execute(self):
        ctx = self.ctx

        # run IEX_BUILD_PACKAGES
        if 'build_packages_task_id' not in ctx:
            ctx['build_packages_task_id'] = \
                self.create_subtask('IEX_BUILD_PACKAGES', 'Sborka paketov', deepcopy(ctx)).id
            self.wait_all_tasks_completed([ctx['build_packages_task_id']])
        else:
            subtask = channel.sandbox.get_task(ctx['build_packages_task_id'])
            if subtask.status != TaskStatus.FINISHED:
                self.set_info(ctx['log_info'] if 'log_info' in ctx else '', False)
                yassert(False, 'Task IEX_BUILD_PACKAGES zavershilsya nekorrektno')
                return

        # sobrat prodakshenovoe okrujenie i tolko chto sobrannye pakety
        if ('build_packages_task_id' in ctx) and ('func_task_id' not in ctx) and ('load_task_id' not in ctx):
            task = channel.sandbox.get_task(ctx['build_packages_task_id'])
            build_packs = list_task_resources(task.id, resource_type='IEX_DEB', get_all_resources=True)
            env_descr = []
            for p in build_packs:
                env_descr += [(IexPrepareRelease.get_package_descr(p), True)]
                ctx[p.attributes['package'] + '_deb'] = p.id
            packages = ['conf', 'grammars', 'remorph', 'patterns', 'server']
            for p in packages:
                if (p + '_deb') in ctx:
                    continue
                r = get_last_resource_with_attrs('IEX_DEB', all_attrs=True, attrs={'package': p, 'released': 'True'})
                env_descr += [(IexPrepareRelease.get_package_descr(r), False)]
                ctx[p + '_deb'] = r.id
            descr = ('<br><font color="' + ('green' if x else 'gray') + '">' + str(pack_info) + '</font>'
                     for pack_info, x in env_descr)
            self.set_info('<font size="6">Environment' + ''.join(descr) + '</font>', False)

        # check run
        run_tests = []
        ctx['build_from_packages'] = True
        if (ctx['test_run']) and ('run_task_ids' not in ctx):
            run_task_ctx = deepcopy(ctx)
            run_task_ctx['tested_entities'] = ''

            ctx['run_task_ids'] = []
            for config_id in ['func', 'load', 'dump', 'prod']:
                run_task_ctx['config_id'] = config_id
                ctx['run_task_ids'] += [(self.create_subtask('IEX_TEST_FUNC',
                                                             'Check running with ' + run_task_ctx['config_id'] + '.cfg',
                                                             run_task_ctx)).id]
            run_tests += ctx['run_task_ids']

        # run IEX_TEST_FUNC
        if (ctx['test_func']) and ('func_task_id' not in ctx):
            ctx['func_task_id'] = (self.create_subtask('IEX_TEST_FUNC', 'Funktsionalnye testy', deepcopy(ctx))).id
            run_tests += [ctx['func_task_id']]

        # run IEX_TEST_LOAD_SB
        if (ctx['test_load']) and ('load_task_ids' not in ctx):
            sub_task_ctx = deepcopy(ctx)
            sub_task_ctx['config_id'] = 'load'
            for shoot in SHOOTS:
                sub_task_ctx[shoot] = False

            ctx['load_task_ids'] = []
            for shoot in SHOOTS:
                if not ctx[shoot]:
                    continue

                sub_task_ctx[shoot] = True
                ctx['load_task_ids'] += [(self.create_subtask('IEX_TEST_LOAD_SB_WITH_RETRY', 'Load testing ' + shoot,
                                                              sub_task_ctx)).id]
                sub_task_ctx[shoot] = False
            run_tests += ctx['load_task_ids']

        if run_tests != []:
            self.wait_all_tasks_completed(run_tests)

        if (ctx['test_func']) and ('func_task_id' in ctx) and ('compare_func_test_results_task_id' not in ctx):
            ctx['old_ans_resource_id'] = get_last_resource_with_attrs('IEX_FUNC_TEST_RESULT', all_attrs=True,
                                                                      attrs={'released': 'True'}).id
            ctx['new_ans_resource_id'] = list_task_resources(ctx['func_task_id'], 'IEX_FUNC_TEST_RESULT')[0].id
            ctx['compare_func_test_results_task_id'] = (
                self.create_subtask(task_type='IEX_COMPARE_FUNC_TEST_RESULTS', input_parameters=deepcopy(ctx),
                                    description='Sravnenie tekushej vydachi s vydachej proshlogo reliza')).id
            self.wait_all_tasks_completed([ctx['compare_func_test_results_task_id']])

        # get subtask's log and may be stop
        ctx['log_info'] = ''

        subtask_ids = [ctx['build_packages_task_id']] + \
            (ctx['run_task_ids'] if ctx['test_run'] else []) + \
            ([ctx['func_task_id'], ctx['compare_func_test_results_task_id']] if ctx['test_func'] else []) + \
            (ctx['load_task_ids'] if ctx['test_load'] else [])
        for subtask_id in subtask_ids:
            subtask = channel.sandbox.get_task(subtask_id)
            info = subtask.info.splitlines()[-1]
            log = '<a href="{0}">{1} was {2}:</a><br>{3}<br><br>'.format(subtask.url, subtask.description,
                                                                         subtask.status, info)
            ctx['log_info'] += log

        if 'compare_func_test_results_task_id' in ctx:
            diff_res = list_task_resources(ctx['compare_func_test_results_task_id'], 'IEX_DIFF_FUNC_RESULTS')[0]
            self.set_info('<a href={0}><font size="6">Diff s predydushim relizom. '
                          'Fajly s diffami pomecheny vosklitsatelnym znakom</font></a>'.format(diff_res.url), False)

        ctx['log_info'] += ("<a href=\"https://sandbox.yandex-team.ru/sandbox/tasks/view?task_id={0}#children\">"
                            "View tests results</a>".format(self.id))
        self.set_info(ctx['log_info'], False)
        all_finished = not (False in [channel.sandbox.get_task(t).status == TaskStatus.FINISHED for t in subtask_ids])
        yassert(all_finished, 'Taski zavershilis neuspeshno!')


__Task__ = IexPrepareRelease
