# -*- coding: utf-8 -*-
from os import system
from time import sleep

import sandbox.common.types.client as ctc

from sandbox.projects.common.apihelpers import list_task_resources
import sandbox.projects.common.debpkg
from sandbox.sandboxsdk import ssh
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.process import run_process as run
from sandbox.sandboxsdk.task import SandboxTask

from sandbox.projects.PSUtil import yassert, print_err, has_page, print_folder_tree


class IexRelease(SandboxTask):
    class PrepareReleaseTaskId(parameters.SandboxIntegerParameter):
        name = 'prepare_release_task_id'
        description = 'PrepareRelease task id'

    type = 'IEX_RELEASE'
    execution_space = 5000
    client_tags = ctc.Tag.LINUX_PRECISE
    input_parameters = [PrepareReleaseTaskId]

    DUPLOAD_CONF = {
        'common': {
            'fqdn': "common.dupload.dist.yandex.ru",
            'method': "scpb",
            'login': "robot-iex-ci",
            'incoming': "/repo/common/mini-dinstall/incoming/",
            'dinstall_runs': 1,
        },
        'search': {
            'fqdn': "search.dupload.dist.yandex.ru",
            'method': "scpb",
            'login': "robot-iex-ci",
            'incoming': "/repo/search/mini-dinstall/incoming/",
            'dinstall_runs': 1,
        },
        'yandex-precise': {
            'fqdn': "yandex-precise.dupload.dist.yandex.ru",
            'method': "scpb",
            'login': "robot-iex-ci",
            'incoming': "/repo/yandex-precise/mini-dinstall/incoming/",
            'dinstall_runs': 1,
        }
    }

    def __init__(self, task_id=0):
        SandboxTask.__init__(self, task_id)

    def upload_to_repo(self, pack_name):
        if 'precise' in self.client_info['platform']:
            platform = 'precise'
        else:
            return False

        repo_id = 'yandex-' + platform
        repo_url = 'http://dist.yandex.ru/' + repo_id + '/<dir>/amd64/'
        repo_dirs = ['intra', 'testing', 'prestable', 'unstable', 'stable', 'stable-prep2remove', 'testing-prep2remove']
        pack_url = repo_url + pack_name + '.deb'
        for folder in repo_dirs:
            if has_page(pack_url.replace('<dir>', folder), self):
                print_err(self, 'ERROR in upload to repo: package ' + pack_url + ' exists')
                return False

        run(['chmod', '-R', 'a+xrw', self.abs_path()])
        with sandbox.projects.common.debpkg.DebRelease(self.DUPLOAD_CONF) as deb:
            with ssh.Key(self, 'IEX-CI', 'robot-iex-ci-ssh-private-key2'):
                work_dir = self.abs_path('_'.join(pack_name.split('_')[:-1]).replace('_', '-'))
                system('cp -f ' + self.abs_path() + '/' + '_'.join(pack_name.split('_')[:-1]) + '* ' + work_dir)
                self.set_info('work_dir = ' + work_dir)

                print_folder_tree(self, self.abs_path(), recursive=True)
                deb.debrelease(['--to', repo_id], work_dir=work_dir)
        sleep(90)

        # test
        if not (has_page(pack_url.replace('<dir>', 'unstable'), self)):
            print_err(self, 'Package ' + pack_name + '.deb did not upload')
            return False
        self.set_info('Package ' + pack_name + '.deb uploaded')
        return True

    def on_execute(self):
        prepare_task = channel.sandbox.get_task(self.ctx['prepare_release_task_id'])

        # получить список пакетов
        build_packages_task_id = prepare_task.ctx['build_packages_task_id']
        build_packs = list_task_resources(build_packages_task_id, resource_type='IEX_DEB', get_all_resources=True)

        # загрузить пакеты
        success = True
        for p in build_packs:
            self.set_info('Upload <a href="{0}">resource</a> from <a href="{1}">task</a>'
                          .format(p.url, channel.sandbox.get_task(p.task_id).url), do_escape=False)
            p_path = self.sync_resource(p)
            pack_name = 'iex-' + p.attributes['package'] + '_0.' + str(p.attributes['version']) + '_amd64'
            work_dir = self.abs_path('_'.join(pack_name.split('_')[:-1]).replace('_', '-'))
            system('mkdir -p "' + work_dir + '"')
            system('cp -fR ' + p_path + '/* ' + work_dir)
            system('cp -f ' + self.abs_path() + '/' + '_'.join(pack_name.split('_')[:-1]) + '* ' + work_dir)
            system('cp -f ' + p_path + '/* ' + self.abs_path())
            if self.upload_to_repo(pack_name):
                channel.sandbox.set_resource_attribute(p.id, 'released', 'True')
            else:
                success = False

        if success and ('test_func' in prepare_task.ctx):
            func_test_result = list_task_resources(prepare_task.ctx['func_task_id'], 'IEX_FUNC_TEST_RESULT')
            if len(func_test_result) != 0:
                channel.sandbox.set_resource_attribute(func_test_result[0].id, 'released', 'True')

        yassert(success, '')


__Task__ = IexRelease
