import codecs
import json
import getopt
import sys


def get_beauty_json(input_json_file, output_json_file):
    # open  file
    input_file = file(input_json_file, "r")
    # need to use codecs for output to avoid error in json.dump
    output_file = codecs.open(output_json_file, "w", encoding="utf-8")

    # read the file and decode possible UTF-8 signature at the beginning
    # which can be the case in some files.
    input_text = input_file.read()
    if input_text != '':
        j = json.loads(input_text.decode("utf-8-sig"))
        # then output it, indenting, sorting keys and ensuring representation as it was originally
        json.dump(j, output_file, indent=4, sort_keys=True, ensure_ascii=False)
    else:
        output_file.write('')


def main(argv):
    input_json_file = None
    output_json_file = None
    try:
        opts, args = getopt.getopt(argv, "hi:o:", ["input_beee_json_file=", "output_beauty_json_file="])
    except getopt.GetoptError:
        print 'get_beauty_json.py -i <input_beee_json_file> -o <output_beauty_json_file>'
        sys.exit(2)
    for opt, arg in opts:
        if opt == '-h':
            print 'get_beauty_json.py -i <input_beee_json_file> -o <output_beauty_json_file>'
            sys.exit()
        elif opt in ("-i", "--input_beee_json_file"):
            input_json_file = arg
        elif opt in ("-o", "--output_beauty_json_file"):
            output_json_file = arg
    get_beauty_json(input_json_file, output_json_file)


if __name__ == "__main__":
    reload(sys)
    sys.setdefaultencoding('utf-8')
    main(sys.argv[1:])
