# -*- coding: utf-8 -*
import json
import logging
import shutil
from time import sleep

from sandbox.projects.resource_types import IEX, IEX_DICTS, IEX_REMORPH_GRAMMARS, MARKET_CONFIG, IEX_DEB, IEX_CONTENTLINE_MODEL
from sandbox.projects.common import apihelpers
from sandbox.projects.resource_types import IEX_TESTS
from sandbox.sandboxsdk import parameters
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.errors import SandboxSvnPathNotExists, SandboxSubprocessError, SandboxSvnError
from sandbox.sandboxsdk.svn import Arcadia, ArcadiaTestData
from sandbox.sandboxsdk.paths import make_folder
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.PSUtil import read_text, replace, recursive_replace, print_folder_tree, download_text, read_text_from_url

# common info: (docs extension, has load tests, has func tests in aqua)
ENTITIES_WITH_TESTS = 'sanitizer'
ENTITIES_INFO = {
    # 'sanitizer':  ('-',    True,  True),

    # 'mixed':      ('-',    True,  False),  # smeshannye patrony
    'addr':         ('txt',  False, True),
    'bounce':       ('txt',  False, True),
    'business':     ('txt',  False, False),
    'classifier':   ('txt',  True,  True),
    'cloud':        ('html', True,  True),
    'contacts':     ('html', False, True),  # dlya abook_contacts (NE dlya contacts) est nagruzochnye testy
    'contentline':  ('html', True,  False),
    'date':         ('txt',  False, True),
    'delivery':     ('html', True,  True),
    'events':       ('txt',  True,  True),
    'happiness':    ('html', False, False),
    'hotels':       ('html', False, True),
    'message':      ('html', True,  False),
    'railway':      ('txt',  False, False),
    'registration': ('html', True,  True),
    'snippet':      ('html', False, False),
    'taxi':         ('html', False, False),
    'thelink':      ('txt',  True,  False),
    'ticket':       ('html', False, True),
    'unsubscribe':  ('html', True,  True),
    'vacancies':    ('txt',  False, False),
    'vehicles':     ('txt',  False, False)
}

ENTITIES = [e for e in ENTITIES_INFO]

DOCS_EXT = {e: ENTITIES_INFO[e][0] for e in ENTITIES_INFO}

ENTITIES_WITH_TESTS_IN_AQUA = [e for e in ENTITIES_INFO if ENTITIES_INFO[e][2]] + ['sanitizer']

SHOOTS = ['test_' + e + '_max_rps' for e in ENTITIES_INFO if ENTITIES_INFO[e][1]] + \
         ['test_' + e + '_timings' for e in ENTITIES_INFO if ENTITIES_INFO[e][1]] + \
         ['test_abook_contacts_max_rps', 'test_abook_contacts_timings', 'test_mixed_max_rps', 'test_mixed_timings']


class TestedEntities(parameters.SandboxStringParameter):
    name = 'tested_entities'
    description = 'Testiruemye ruchki cherez zapyatuyu'
    default_value = ','.join(ENTITIES)


TESTS = [TestedEntities] + [
    type(''.join((e[0].upper(), e[1:], "TestsResourceId")), (parameters.ResourceSelector,), {
        'name': e + '_tests_resource_id',
        'description': e + ' tests',
        'resource_type': IEX_TESTS,
        'required': True
    })
    for e in ENTITIES
]


# imbalance
class Ticket(parameters.SandboxStringParameter):
    name = 'ticket'
    description = 'Jira/st ticket'
    default_value = 'IEX-366'


class User(parameters.SandboxStringParameter):
    name = 'user'
    description = 'Kuda strelyat. Polzovatel'
    default_value = 'robot-iex-ci'


class Notify(parameters.SandboxStringParameter):
    name = 'notify'
    description = 'Kogo uvedomlyat o zapuske'


class Mailto(parameters.SandboxStringParameter):
    name = 'mailto'
    description = 'Pismo o fejle otpravlyat'
    default_value = 'avalanche@yandex-team.ru,kohen@yandex-team.ru,ren0@yandex-team.ru'


LOAD_COMMON_SETTINGS = [Ticket, User, Notify, Mailto]


# --------------------------------------------------------------------------------
class AutostopLineMixedMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_mixed_max_rps'
    description = 'Usloviya avtozaversheniya'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'


class RegressionCompoMixedMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_mixed_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'
    default_value = 'iex_mixed_max_rps'


class DescrMixedMaxRps(parameters.SandboxStringParameter):
    name = 'descr_mixed_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskMixedMaxRps(parameters.SandboxStringParameter):
    name = 'task_mixed_max_rps'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'
    default_value = 'mixed-00.ammo:line(1,300,10m)'


class TestMixedMaxRps(parameters.SandboxBoolParameter):
    default_value = True
    name = 'test_mixed_max_rps'
    description = 'Testirovat mixed_max_rps'
    sub_fields = {'true': [
        AutostopLineMixedMaxRps.name, RegressionCompoMixedMaxRps.name,
        DescrMixedMaxRps.name, TaskMixedMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineMixedTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_mixed_timings'
    description = 'Usloviya avtozaversheniya'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'


class RegressionCompoMixedTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_mixed_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'
    default_value = 'iex_mixed_timings'


class DescrMixedTimings(parameters.SandboxStringParameter):
    name = 'descr_mixed_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskMixedTimings(parameters.SandboxStringParameter):
    name = 'task_mixed_timings'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'
    default_value = 'mixed-00.ammo:line(1,40,1m) const(40,10m)'


class TestMixedTimings(parameters.SandboxBoolParameter):
    default_value = True
    name = 'test_mixed_timings'
    description = 'Testirovat mixed_timings'
    sub_fields = {'true': [
        AutostopLineMixedTimings.name, RegressionCompoMixedTimings.name,
        DescrMixedTimings.name, TaskMixedTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineAbookContactsMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_abook_contacts_max_rps'
    description = 'Usloviya dlya avtozaversheniya'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'


class RegressionCompoAbookContactsMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_abook_contacts_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'
    default_value = 'iex_abook-contacts_max_rps'


class DescrAbookContactsMaxRps(parameters.SandboxStringParameter):
    name = 'descr_abook_contacts_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskAbookContactsMaxRps(parameters.SandboxStringParameter):
    name = 'task_abook_contacts_max_rps'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'
    default_value = 'abook-contacts.ammo:line(1,700,10m)'


class TestAbookContactsMaxRps(parameters.SandboxBoolParameter):
    default_value = True
    name = 'test_abook_contacts_max_rps'
    description = 'Testirovat abook-contacts_max_rps'
    sub_fields = {'true': [
        AutostopLineAbookContactsMaxRps.name, RegressionCompoAbookContactsMaxRps.name,
        DescrAbookContactsMaxRps.name, TaskAbookContactsMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineAbookContactsTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_abook_contacts_timings'
    description = 'Usloviya avtozaversheniya'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'


class RegressionCompoAbookContactsTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_abook_contacts_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'
    default_value = 'iex_abook-contacts_timings'


class DescrAbookContactsTimings(parameters.SandboxStringParameter):
    name = 'descr_abook_contacts_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskAbookContactsTimings(parameters.SandboxStringParameter):
    name = 'task_abook_contacts_timings'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'
    default_value = 'abook-contacts.ammo:line(1,200,1m) const(200,10m)'


class TestAbookContactsTimings(parameters.SandboxBoolParameter):
    default_value = True
    name = 'test_abook_contacts_timings'
    description = 'Testirovat abook-contacts_timings'
    sub_fields = {'true': [
        AutostopLineAbookContactsTimings.name, RegressionCompoAbookContactsTimings.name,
        DescrAbookContactsTimings.name, TaskAbookContactsTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineCloudMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_cloud_max_rps'
    description = 'Usloviya avtozaversheniya'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'


class RegressionCompoCloudMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_cloud_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'
    default_value = 'iex_cloud_max_rps'


class DescrCloudMaxRps(parameters.SandboxStringParameter):
    name = 'descr_cloud_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskCloudMaxRps(parameters.SandboxStringParameter):
    name = 'task_cloud_max_rps'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'
    default_value = 'cloud.ammo:line(1,4000,10m)'


class TestCloudMaxRps(parameters.SandboxBoolParameter):
    default_value = True
    name = 'test_cloud_max_rps'
    description = 'Testirovat cloud_max_rps'
    sub_fields = {'true': [
        AutostopLineCloudMaxRps.name, RegressionCompoCloudMaxRps.name,
        DescrCloudMaxRps.name, TaskCloudMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineCloudTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_cloud_timings'
    description = 'Usloviya avtozaversheniya'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'


class RegressionCompoCloudTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_cloud_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'
    default_value = 'iex_cloud_timings'


class DescrCloudTimings(parameters.SandboxStringParameter):
    name = 'descr_cloud_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskCloudTimings(parameters.SandboxStringParameter):
    name = 'task_cloud_timings'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'
    default_value = 'cloud.ammo:line(1,1000,1m) const(1000,10m)'


class TestCloudTimings(parameters.SandboxBoolParameter):
    default_value = True
    name = 'test_cloud_timings'
    description = 'Testirovat cloud_timings'
    sub_fields = {'true': [
        AutostopLineCloudTimings.name, RegressionCompoCloudTimings.name,
        DescrCloudTimings.name, TaskCloudTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineDeliveryMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_delivery_max_rps'
    description = 'Usloviya avtozaversheniya'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'


class RegressionCompoDeliveryMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_delivery_max_rps'
    default_value = 'iex_delivery_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrDeliveryMaxRps(parameters.SandboxStringParameter):
    name = 'descr_delivery_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskDeliveryMaxRps(parameters.SandboxStringParameter):
    name = 'task_delivery_max_rps'
    default_value = 'delivery.ammo:line(1,4500,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestDeliveryMaxRps(parameters.SandboxBoolParameter):
    default_value = True
    name = 'test_delivery_max_rps'
    description = 'Testirovat delivery_max_rps'
    sub_fields = {'true': [
        AutostopLineDeliveryMaxRps.name, RegressionCompoDeliveryMaxRps.name,
        DescrDeliveryMaxRps.name, TaskDeliveryMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineDeliveryTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_delivery_timings'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoDeliveryTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_delivery_timings'
    default_value = 'iex_delivery_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrDeliveryTimings(parameters.SandboxStringParameter):
    name = 'descr_delivery_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskDeliveryTimings(parameters.SandboxStringParameter):
    name = 'task_delivery_timings'
    default_value = 'delivery.ammo:line(1,700,1m) const(700,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestDeliveryTimings(parameters.SandboxBoolParameter):
    name = 'test_delivery_timings'
    default_value = True
    description = 'Testirovat delivery_timings'
    sub_fields = {'true': [
        AutostopLineDeliveryTimings.name, RegressionCompoDeliveryTimings.name,
        DescrDeliveryTimings.name, TaskDeliveryTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineEventsMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_events_max_rps'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoEventsMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_events_max_rps'
    default_value = 'iex_events_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrEventsMaxRps(parameters.SandboxStringParameter):
    name = 'descr_events_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskEventsMaxRps(parameters.SandboxStringParameter):
    name = 'task_events_max_rps'
    default_value = 'events.ammo:line(1,600,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestEventsMaxRps(parameters.SandboxBoolParameter):
    name = 'test_events_max_rps'
    default_value = True
    description = 'Testirovat events_max_rps'
    sub_fields = {'true': [
        AutostopLineEventsMaxRps.name, RegressionCompoEventsMaxRps.name,
        DescrEventsMaxRps.name, TaskEventsMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineEventsTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_events_timings'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoEventsTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_events_timings'
    default_value = 'iex_events_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrEventsTimings(parameters.SandboxStringParameter):
    name = 'descr_events_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskEventsTimings(parameters.SandboxStringParameter):
    name = 'task_events_timings'
    default_value = 'events.ammo:line(1,150,1m) const(150,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestEventsTimings(parameters.SandboxBoolParameter):
    name = 'test_events_timings'
    default_value = True
    description = 'Testirovat events_timings'
    sub_fields = {'true': [
        AutostopLineEventsTimings.name, RegressionCompoEventsTimings.name,
        DescrEventsTimings.name, TaskEventsTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineClassifierMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_classifier_max_rps'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoClassifierMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_classifier_max_rps'
    default_value = 'iex_classifier_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrClassifierMaxRps(parameters.SandboxStringParameter):
    name = 'descr_classifier_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskClassifierMaxRps(parameters.SandboxStringParameter):
    name = 'task_classifier_max_rps'
    default_value = 'classifier.normalized3.ammo:line(1,4000,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestClassifierMaxRps(parameters.SandboxBoolParameter):
    name = 'test_classifier_max_rps'
    default_value = False
    description = 'Testirovat classifier_max_rps'
    sub_fields = {'true': [
        AutostopLineClassifierMaxRps.name, RegressionCompoClassifierMaxRps.name,
        DescrClassifierMaxRps.name, TaskClassifierMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineClassifierTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_classifier_timings'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoClassifierTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_classifier_timings'
    default_value = 'iex_classifier_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrClassifierTimings(parameters.SandboxStringParameter):
    name = 'descr_classifier_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskClassifierTimings(parameters.SandboxStringParameter):
    name = 'task_classifier_timings'
    default_value = 'classifier.normalized3.ammo:line(1,800,1m) const(800,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestClassifierTimings(parameters.SandboxBoolParameter):
    name = 'test_classifier_timings'
    default_value = False
    description = 'Testirovat classifier_timings'
    sub_fields = {'true': [
        AutostopLineClassifierTimings.name, RegressionCompoClassifierTimings.name,
        DescrClassifierTimings.name, TaskClassifierTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineContentlineMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_contentline_max_rps'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoContentlineMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_contentline_max_rps'
    default_value = 'iex_contentline_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrContentlineMaxRps(parameters.SandboxStringParameter):
    name = 'descr_contentline_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskContentlineMaxRps(parameters.SandboxStringParameter):
    name = 'task_contentline_max_rps'
    default_value = 'contentline.ammo:line(1,8500,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestContentlineMaxRps(parameters.SandboxBoolParameter):
    name = 'test_contentline_max_rps'
    default_value = True
    description = 'Testirovat contentline_max_rps'
    sub_fields = {'true': [
        AutostopLineContentlineMaxRps.name, RegressionCompoContentlineMaxRps.name,
        DescrContentlineMaxRps.name, TaskContentlineMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineContentlineTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_contentline_timings'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoContentlineTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_contentline_timings'
    default_value = 'iex_contentline_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrContentlineTimings(parameters.SandboxStringParameter):
    name = 'descr_contentline_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskContentlineTimings(parameters.SandboxStringParameter):
    name = 'task_contentline_timings'
    default_value = 'contentline.ammo:line(1,1300,1m) const(1300,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestContentlineTimings(parameters.SandboxBoolParameter):
    name = 'test_contentline_timings'
    default_value = True
    description = 'Testirovat contentline_timings'
    sub_fields = {'true': [
        AutostopLineContentlineTimings.name, RegressionCompoContentlineTimings.name,
        DescrContentlineTimings.name, TaskContentlineTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineMessageMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_message_max_rps'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoMessageMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_message_max_rps'
    default_value = 'iex_message_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrMessageMaxRps(parameters.SandboxStringParameter):
    name = 'descr_message_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskMessageMaxRps(parameters.SandboxStringParameter):
    name = 'task_message_max_rps'
    default_value = 'message.ammo:line(1,4500,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestMessageMaxRps(parameters.SandboxBoolParameter):
    name = 'test_message_max_rps'
    default_value = True
    description = 'Testirovat message_max_rps'
    sub_fields = {'true': [
        AutostopLineMessageMaxRps.name, RegressionCompoMessageMaxRps.name,
        DescrMessageMaxRps.name, TaskMessageMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineMessageTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_message_timings'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoMessageTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_message_timings'
    default_value = 'iex_message_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrMessageTimings(parameters.SandboxStringParameter):
    name = 'descr_message_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskMessageTimings(parameters.SandboxStringParameter):
    name = 'task_message_timings'
    default_value = 'message.ammo:line(1,1000,1m) const(1000,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestMessageTimings(parameters.SandboxBoolParameter):
    name = 'test_message_timings'
    default_value = True
    description = 'Testirovat message_timings'
    sub_fields = {'true': [
        AutostopLineMessageTimings.name, RegressionCompoMessageTimings.name,
        DescrMessageTimings.name, TaskMessageTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineRegistrationMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_registration_max_rps'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoRegistrationMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_registration_max_rps'
    default_value = 'iex_registration_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrRegistrationMaxRps(parameters.SandboxStringParameter):
    name = 'descr_registration_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskRegistrationMaxRps(parameters.SandboxStringParameter):
    name = 'task_registration_max_rps'
    default_value = 'registration.ammo:line(1,9000,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestRegistrationMaxRps(parameters.SandboxBoolParameter):
    name = 'test_registration_max_rps'
    default_value = True
    description = 'Testirovat registration_max_rps'
    sub_fields = {'true': [
        AutostopLineRegistrationMaxRps.name, RegressionCompoRegistrationMaxRps.name,
        DescrRegistrationMaxRps.name, TaskRegistrationMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineRegistrationTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_registration_timings'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoRegistrationTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_registration_timings'
    default_value = 'iex_registration_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrRegistrationTimings(parameters.SandboxStringParameter):
    name = 'descr_registration_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskRegistrationTimings(parameters.SandboxStringParameter):
    name = 'task_registration_timings'
    default_value = 'registration.ammo:line(1,1000,1m) const(1000,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestRegistrationTimings(parameters.SandboxBoolParameter):
    name = 'test_registration_timings'
    default_value = True
    description = 'Testirovat registration_timings'
    sub_fields = {'true': [
        AutostopLineRegistrationTimings.name, RegressionCompoRegistrationTimings.name,
        DescrRegistrationTimings.name, TaskRegistrationTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineThelinkMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_thelink_max_rps'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoThelinkMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_thelink_max_rps'
    default_value = 'iex_thelink_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrThelinkMaxRps(parameters.SandboxStringParameter):
    name = 'descr_thelink_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskThelinkMaxRps(parameters.SandboxStringParameter):
    name = 'task_thelink_max_rps'
    default_value = 'thelink.ammo:line(1,11000,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestThelinkMaxRps(parameters.SandboxBoolParameter):
    name = 'test_thelink_max_rps'
    default_value = True
    description = 'Testirovat thelink_max_rps'
    sub_fields = {'true': [
        AutostopLineThelinkMaxRps.name, RegressionCompoThelinkMaxRps.name,
        DescrThelinkMaxRps.name, TaskThelinkMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineThelinkTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_thelink_timings'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoThelinkTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_thelink_timings'
    default_value = 'iex_thelink_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrThelinkTimings(parameters.SandboxStringParameter):
    name = 'descr_thelink_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskThelinkTimings(parameters.SandboxStringParameter):
    name = 'task_thelink_timings'
    default_value = 'thelink.ammo:line(1,1800,1m) const(1800,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestThelinkTimings(parameters.SandboxBoolParameter):
    name = 'test_thelink_timings'
    default_value = True
    description = 'Testirovat thelink_timings'
    sub_fields = {'true': [
        AutostopLineThelinkTimings.name, RegressionCompoThelinkTimings.name,
        DescrThelinkTimings.name, TaskThelinkTimings.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineUnsubscribeMaxRps(parameters.SandboxStringParameter):
    name = 'autostop_line_unsubscribe_max_rps'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoUnsubscribeMaxRps(parameters.SandboxStringParameter):
    name = 'regression_compo_unsubscribe_max_rps'
    default_value = 'iex_unsubscribe_max_rps'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrUnsubscribeMaxRps(parameters.SandboxStringParameter):
    name = 'descr_unsubscribe_max_rps'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskUnsubscribeMaxRps(parameters.SandboxStringParameter):
    name = 'task_unsubscribe_max_rps'
    default_value = 'unsubscribe.ammo:line(1,7000,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestUnsubscribeMaxRps(parameters.SandboxBoolParameter):
    name = 'test_unsubscribe_max_rps'
    default_value = True
    description = 'Testirovat unsubscribe_max_rps'
    sub_fields = {'true': [
        AutostopLineUnsubscribeMaxRps.name, RegressionCompoUnsubscribeMaxRps.name,
        DescrUnsubscribeMaxRps.name, TaskUnsubscribeMaxRps.name
    ]}


# --------------------------------------------------------------------------------
class AutostopLineUnsubscribeTimings(parameters.SandboxStringParameter):
    name = 'autostop_line_unsubscribe_timings'
    default_value = 'time(500,5s) http(3xx,1%,5s) http(4xx,1%,5s) http(5xx,1%,5s) net(xx,1%,5s) net(1xx,5%,5s)'
    description = 'Usloviya avtozaversheniya'


class RegressionCompoUnsubscribeTimings(parameters.SandboxStringParameter):
    name = 'regression_compo_unsubscribe_timings'
    default_value = 'iex_unsubscribe_timings'
    description = 'Komponent regressii, k nemu privyazany nastrojki po SLA'


class DescrUnsubscribeTimings(parameters.SandboxStringParameter):
    name = 'descr_unsubscribe_timings'
    description = 'Opisanie strelby, nujno tolko dlya lyudej'


class TaskUnsubscribeTimings(parameters.SandboxStringParameter):
    name = 'task_unsubscribe_timings'
    default_value = 'unsubscribe.ammo:line(1,1000,1m) const(1000,10m)'
    description = 'CHem i skolko strelyat v formate: "fajl_patronov:raspisanie"'


class TestUnsubscribeTimings(parameters.SandboxBoolParameter):
    name = 'test_unsubscribe_timings'
    default_value = True
    description = 'Testirovat unsubscribe_timings'
    sub_fields = {'true': [
        AutostopLineUnsubscribeTimings.name, RegressionCompoUnsubscribeTimings.name,
        DescrUnsubscribeTimings.name, TaskUnsubscribeTimings.name
    ]}


LOAD_SHOOTS_SETTINGS = [
    # --------------------------------------------------------------------------------
    TestMixedMaxRps, AutostopLineMixedMaxRps, RegressionCompoMixedMaxRps,
    DescrMixedMaxRps, TaskMixedMaxRps,
    # --------------------------------------------------------------------------------
    TestMixedTimings, AutostopLineMixedTimings, RegressionCompoMixedTimings,
    DescrMixedTimings, TaskMixedTimings,
    # --------------------------------------------------------------------------------
    TestAbookContactsMaxRps, AutostopLineAbookContactsMaxRps, RegressionCompoAbookContactsMaxRps,
    DescrAbookContactsMaxRps, TaskAbookContactsMaxRps,
    # --------------------------------------------------------------------------------
    TestAbookContactsTimings, AutostopLineAbookContactsTimings, RegressionCompoAbookContactsTimings,
    DescrAbookContactsTimings, TaskAbookContactsTimings,
    # --------------------------------------------------------------------------------
    TestCloudMaxRps, AutostopLineCloudMaxRps, RegressionCompoCloudMaxRps,
    DescrCloudMaxRps, TaskCloudMaxRps,
    # --------------------------------------------------------------------------------
    TestCloudTimings, AutostopLineCloudTimings, RegressionCompoCloudTimings,
    DescrCloudTimings, TaskCloudTimings,
    # --------------------------------------------------------------------------------
    TestDeliveryMaxRps, AutostopLineDeliveryMaxRps, RegressionCompoDeliveryMaxRps,
    DescrDeliveryMaxRps, TaskDeliveryMaxRps,
    # --------------------------------------------------------------------------------
    TestDeliveryTimings, AutostopLineDeliveryTimings, RegressionCompoDeliveryTimings,
    DescrDeliveryTimings, TaskDeliveryTimings,
    # --------------------------------------------------------------------------------
    TestEventsMaxRps, AutostopLineEventsMaxRps, RegressionCompoEventsMaxRps,
    DescrEventsMaxRps, TaskEventsMaxRps,
    # --------------------------------------------------------------------------------
    TestEventsTimings, AutostopLineEventsTimings, RegressionCompoEventsTimings,
    DescrEventsTimings, TaskEventsTimings,
    # --------------------------------------------------------------------------------
    TestClassifierMaxRps, AutostopLineClassifierMaxRps, RegressionCompoClassifierMaxRps,
    DescrClassifierMaxRps, TaskClassifierMaxRps,
    # --------------------------------------------------------------------------------
    TestClassifierTimings, AutostopLineClassifierTimings, RegressionCompoClassifierTimings,
    DescrClassifierTimings, TaskClassifierTimings,
    # --------------------------------------------------------------------------------
    TestContentlineMaxRps, AutostopLineContentlineMaxRps, RegressionCompoContentlineMaxRps,
    DescrContentlineMaxRps, TaskContentlineMaxRps,
    # --------------------------------------------------------------------------------
    TestContentlineTimings, AutostopLineContentlineTimings, RegressionCompoContentlineTimings,
    DescrContentlineTimings, TaskContentlineTimings,
    # --------------------------------------------------------------------------------
    TestMessageMaxRps, AutostopLineMessageMaxRps, RegressionCompoMessageMaxRps,
    DescrMessageMaxRps, TaskMessageMaxRps,
    # --------------------------------------------------------------------------------
    TestMessageTimings, AutostopLineMessageTimings, RegressionCompoMessageTimings,
    DescrMessageTimings, TaskMessageTimings,
    # --------------------------------------------------------------------------------
    TestRegistrationMaxRps, AutostopLineRegistrationMaxRps, RegressionCompoRegistrationMaxRps,
    DescrRegistrationMaxRps, TaskRegistrationMaxRps,
    # --------------------------------------------------------------------------------
    TestRegistrationTimings, AutostopLineRegistrationTimings, RegressionCompoRegistrationTimings,
    DescrRegistrationTimings, TaskRegistrationTimings,
    # --------------------------------------------------------------------------------
    TestThelinkMaxRps, AutostopLineThelinkMaxRps, RegressionCompoThelinkMaxRps,
    DescrThelinkMaxRps, TaskThelinkMaxRps,
    # --------------------------------------------------------------------------------
    TestThelinkTimings, AutostopLineThelinkTimings, RegressionCompoThelinkTimings,
    DescrThelinkTimings, TaskThelinkTimings,
    # --------------------------------------------------------------------------------
    TestUnsubscribeMaxRps, AutostopLineUnsubscribeMaxRps, RegressionCompoUnsubscribeMaxRps,
    DescrUnsubscribeMaxRps, TaskUnsubscribeMaxRps,
    # --------------------------------------------------------------------------------
    TestUnsubscribeTimings, AutostopLineUnsubscribeTimings, RegressionCompoUnsubscribeTimings,
    DescrUnsubscribeTimings, TaskUnsubscribeTimings,
]

RETURN_CODE_TO_MSG = {
    0: "completed",
    1: "interrupted_generic_interrupt",
    2: "interrupted",
    3: "interrupted_active_task_not_found ",
    4: "interrupted_no_ammo_file",
    5: "interrupted_address_not_specified",
    6: "interrupted_cpu_or_disk_overload",
    7: "interrupted_unknown_config_parameter",
    8: "interrupted_stop_via_web",
    9: "interrupted",
    11: "interrupted_job_number_error",
    12: "interrupted_phantom_error",
    13: "interrupted_job_metainfo_error",
    14: "interrupted_target_monitoring_error",
    15: "interrupted_target_info_error",
    21: "autostop_time",
    22: "autostop_http",
    23: "autostop_net",
    24: "autostop_instances",
    25: "autostop_total_time",
    26: "autostop_total_http",
    27: "autostop_total_net",
    28: "autostop_negative_http",
    29: "autostop_negative_net",
    30: "autostop_http_trend",
    31: "autostop_metric_higher",
    32: "autostop_metric_lower"
}


def get_shoots_list(self):
    all_shoots = []
    for field in LOAD_SHOOTS_SETTINGS:
        if field[0].startswith('test_'):
            all_shoots += [field[0][5:]]
    logging.info(str(all_shoots))
    return [s for s in all_shoots if self.ctx['test_' + s.replace('-', '_')]]


def get_field(maps, field_name, field_value, interesting_field):
    """
    Na vhod prinimaet massiv slovarej maps. Nahodit slovar, soderjashij field_name: field_value. Vozvrashaet znachenie
    polya interesting_field etogo slovarya.
    """
    m = None
    for m in maps:
        if m[field_name] == field_value:
            break
    if m[field_name] != field_value:
        return None
    return m[interesting_field]


def get_data_about_shoot_by_descr(self, descr, regression_n, interesting_field):
    all_shoots_info_url = 'http://lunapark.yandex-team.ru/api/regress/<regression_n>/joblist.json'
    shoot_info_url = all_shoots_info_url.replace('<regression_n>', str(regression_n))
    download_text(shoot_info_url, self.log_path('joblist.json'))
    return get_field(json.loads(read_text_from_url(shoot_info_url)), 'name', descr, interesting_field)


def get_imbalance(self, entity, shoot_type, descr):
    regression_info_url = 'https://lunapark.yandex-team.ru/api/regress/IEX/componentlist.json'
    regression_info = json.loads(read_text_from_url(regression_info_url))
    self.set_info('Entity name: ' + str(entity) + ', shoot type: ' + str(shoot_type) + '.')
    regression_n = get_field(regression_info, 'name', 'iex_' + str(entity) + '_' + str(shoot_type), 'n')

    self.set_info('regression_n = ' + str(regression_n))
    shoot_n = get_data_about_shoot_by_descr(self, descr, regression_n, 'n')
    if shoot_n is None:
        sleep(5*60)
        shoot_n = get_data_about_shoot_by_descr(self, descr, regression_n, 'n')
    if shoot_n is None:
        sleep(10*60)
        shoot_n = get_data_about_shoot_by_descr(self, descr, regression_n, 'n')
    if shoot_n is None:
        return shoot_n, 999999, False, 'Ne udalos poluchit rezultaty'

    sla_data_about_shoot_url = 'https://lunapark.yandex-team.ru/api/job/<shoot_n>/sla.json'
    self.set_info('shoot_n = ' + str(shoot_n))

    sla_data_url = sla_data_about_shoot_url.replace('<shoot_n>', str(shoot_n))
    sla_data = json.loads(read_text_from_url(sla_data_url))
    if 'resolution' in sla_data[0]:
        test_pass = sla_data[0]['resolution']
    else:
        sleep(5*60)
        sla_data = json.loads(read_text_from_url(sla_data_url))
        test_pass = sla_data[0]['resolution']

    imbalance = get_data_about_shoot_by_descr(self, descr, regression_n, 'imbalance')
    if imbalance == 0:
        last_second_rps = get_data_about_shoot_by_descr(self, descr, regression_n, 'last_second_rps')
        imbalance = last_second_rps
        if (not test_pass) and ('888' in sla_data[0]['failed_kpis']):
            failed_values = sla_data[0]['failed_kpis']['888']['failed_values']
            fail_reason_is_imbalance = (len(sla_data[0]['failed_kpis']) == 1) and (len(failed_values) == 1) and \
                                       ('imbalance' in failed_values)
            test_pass = fail_reason_is_imbalance  # and (last_second_rps != 0)
    error_msg = ''
    if 'failed_kpis' in sla_data[0]:
        for failed_kpi in sla_data[0]['failed_kpis']:
            error_msg += sla_data[0]['failed_kpis'][failed_kpi]['dsc'] + '<br />'
            failed_values = sla_data[0]['failed_kpis'][failed_kpi]['failed_values']
            for failed_value in failed_values:
                error_msg += 'failed value = ' + failed_value \
                             + ': actual ' + str(failed_values[failed_value]['actual']) \
                             + ', threshold ' + str(failed_values[failed_value]['threshold']) + '<br />'
            error_msg += '<br />'
    return shoot_n, imbalance, test_pass, error_msg


# download

def check_that_resource_is_defined(self, resource_id, resource_name, comment=''):
    self.yassert(resource_id != 0, 'Resurs' + resource_name + ' ne vybran. ' + comment)


PACKAGES = ['conf', 'grammars', 'remorph', 'patterns', 'server']

IEX_PACKAGES_FIELDS = [
    type(''.join((p[0].upper(), p[1:], 'Deb')), (parameters.ResourceSelector,), {
        'name': p + '_deb',
        'description': p + ' package',
        'resource_type': IEX_DEB,
        'required': True,
    })
    for p in PACKAGES
]


def download_iex_packages(self, l1_threads_count, config_id):
    packages_info = []
    for pack in PACKAGES:
        self.set_info(pack)
        check_that_resource_is_defined(self, self.ctx[pack + '_deb'], 'IEX_TESTS')
        pack_dir = self.sync_resource(self.ctx[pack + '_deb'])
        deb_path = pack_dir + '/' + (pack_dir.split('/')[-1]).replace('-0.', '_0.') + '_amd64.deb'
        run_process(['chmod', '-R', 'a+xwr', self.abs_path()])
        print_folder_tree(self, self.abs_path(), recursive=True)
        run_process(['dpkg', '--extract', deb_path, self.abs_path()])
        print_folder_tree(self, self.abs_path(), recursive=True)
        packages_info += [(pack, channel.sandbox.get_resource(self.ctx[pack + '_deb']).attributes['version'])]

    config_path = self.abs_path('usr/share/iex/' + config_id + '.cfg')
    dicts_path = self.abs_path('usr/share/iex/grammars')
    remorph_path = self.abs_path('usr/share/iex/remorph')
    packages = self.abs_path('usr/share/iex')
    change_paths_in_confs(self, config_path, packages, dicts_path, remorph_path, l1_threads_count)

    server_path = self.abs_path('usr/bin/iexsrv')
    return packages_info, server_path, config_path


class IexResourceId(parameters.ResourceSelector):
    name = 'iex_resource_id'
    description = 'IEX binary'
    resource_type = IEX
    required = True


class DictsResourceId(parameters.ResourceSelector):
    name = 'dicts_resource_id'
    description = 'Grammars'
    resource_type = IEX_DICTS
    required = True


class RemorphResourceId(parameters.ResourceSelector):
    name = 'remorph_resource_id'
    description = 'Remorph grammars'
    resource_type = IEX_REMORPH_GRAMMARS
    required = True


class ContentlineModelResourceId(parameters.ResourceSelector):
    name = 'contentline_model_resource_id'
    description = 'Contentline model'
    resource_type = IEX_CONTENTLINE_MODEL
    required = True


class MarketConfigResourceId(parameters.ResourceSelector):
    name = 'market_config_resource_id'
    description = 'Market config'
    resource_type = MARKET_CONFIG
    required = True


class UseSpecificMarketConfig(parameters.SandboxBoolParameter):
    default_value = True
    name = 'use_specific_market_config'
    description = 'Use specific market config (use last MARKET_CONFIG resource by default )'
    sub_fields = {'true': [MarketConfigResourceId.name]}


class PackagesPatch(parameters.SandboxStringParameter):
    name = 'packages_patch'
    description = (
        'Apply patch. Input patch text (non-ascii symbols will be ignored)'
        ' or diff file\'s rbtorrent id (diff should be taken from arcadia_tests_data/yweb/iex/packages root)'
    )
    multiline = True


class SvnRevision(parameters.SandboxStringParameter):
    name = 'svn_revision'
    description = 'Revision'


IEX_FROM_SVN = [
    IexResourceId,
    DictsResourceId,
    RemorphResourceId,

    ContentlineModelResourceId,
    UseSpecificMarketConfig,
    MarketConfigResourceId,
    PackagesPatch,
    SvnRevision,
]


class ConfigId(parameters.SandboxStringParameter):
    name = 'config_id'
    description = 'Config identification (func/dump/load/prod)'
    default_value = 'func'


class BuildFromPackages(parameters.SandboxBoolParameter):
    name = 'build_from_packages'
    description = 'Build from packages'
    sub_fields = {
        'false': [_.name for _ in IEX_FROM_SVN],
        'true': [_.name for _ in IEX_PACKAGES_FIELDS]
    }


FIELDS_FOR_DOWNLOAD = [ConfigId, BuildFromPackages] + IEX_FROM_SVN + IEX_PACKAGES_FIELDS


def get_env_conf(task):
    env_conf = ArcadiaTestData.get_arcadia_test_data(
        task, 'arcadia:/arc/trunk/arcadia_tests_data/yweb/iex/packages/iex_env.json')
    return json.loads(read_text(env_conf))


def download_env(task, env_conf, env, revision):
    for folder in env_conf[env]:
        for arc_path in env_conf[env][folder]:
            try:
                arc_full_path = 'arcadia:/arc/trunk/' + arc_path + '@' + str(revision)
                local_path = env + ('' if folder == '.' else ('/' + folder))
                task.set_info('Download ' + arc_full_path + ' to ' + local_path)
                try:
                    Arcadia.export(arc_full_path, local_path, revision=revision)
                except SandboxSvnPathNotExists:
                    raise SandboxSubprocessError('ERROR at download_env: ' + arc_full_path + ' does not exist.')
                except SandboxSvnError:
                    raise SandboxSubprocessError('ERROR at download_env: some problems with SVN.')
            except:
                pass


def download_server(self):
    check_that_resource_is_defined(self, self.ctx['iex_resource_id'], 'IEX')
    return self.sync_resource(self.ctx['iex_resource_id'])


def download_contentline_learner(self):
    check_that_resource_is_defined(self, self.ctx['iex_contentline_learner_resource_id'], 'IEX_CONTENTLINE_LEARNER')
    return self.sync_resource(self.ctx['iex_contentline_learner_resource_id'])


def download_contentline_model(self, dest_path=None):
    check_that_resource_is_defined(self, self.ctx['contentline_model_resource_id'], 'IEX_CONTENTLINE_MODEL')
    model_path = self.sync_resource(self.ctx['contentline_model_resource_id'])
    if dest_path is None:
        return model_path
    make_folder(dest_path)
    run_process(['cp', '-r', model_path, dest_path])
    return dest_path


def download_dicts(self):
    check_that_resource_is_defined(self, self.ctx['dicts_resource_id'], 'IEX_DICTS')
    dicts = self.sync_resource(self.ctx['dicts_resource_id'])
    run_process(['cp', '-r', dicts, self.abs_path()])
    run_process(['chmod', '-R', 'a+xwr', self.abs_path()])
    return self.abs_path(dicts.split('/')[-1])


def download_remorph(self):
    check_that_resource_is_defined(self, self.ctx['remorph_resource_id'], 'IEX_REMORPH_GRAMMARS')
    return self.sync_resource(self.ctx['remorph_resource_id'])


def select_market_config(self):
    if self.ctx['use_specific_market_config']:
        check_that_resource_is_defined(self, self.ctx['market_config_resource_id'], 'MARKET_CONFIG',
                                       'Vyberite resurs ili snimite galochku "Use specific market config"')
        return channel.sandbox.get_resource(self.ctx['market_config_resource_id'])
    else:
        return apihelpers.get_last_resource('MARKET_CONFIG')


def download_market_config(self, packages_dir):
    xml_patterns_json = self.sync_resource(select_market_config(self))
    shutil.copy(xml_patterns_json, packages_dir)


def download_configs(self, env_conf, revision, config_id):
    download_env(self, env_conf, 'packages', revision)
    if self.ctx['packages_patch'] != u'':
        Arcadia.apply_patch(self.abs_path('packages'), self.ctx['packages_patch'] + '\n', self.log_path())
    return self.abs_path('packages/' + config_id + '.cfg')


def download_iex_from_resources_and_svn(self, l1_threads_count=None, config_id='func'):
    env_conf = get_env_conf(self)
    self.set_info(env_conf)
    iex_build_resource = channel.sandbox.get_resource(self.ctx['iex_resource_id'])
    revision = int(iex_build_resource.attributes['revision'])

    server_path = download_server(self)
    dict_path = download_dicts(self)
    remorph_path = download_remorph(self)
    packages_dir = self.abs_path('packages')
    make_folder(packages_dir)
    config_path = download_configs(self, env_conf, revision, config_id)
    download_contentline_model(self, packages_dir + '/settings')
    download_market_config(self, packages_dir)

    change_paths_in_confs(self, config_path, packages_dir, dict_path, remorph_path, l1_threads_count)
    print_folder_tree(self, self.abs_path(), recursive=True)
    return revision, server_path, config_path


def download_iex(self, l1_threads_count=None, config_id='func'):
    if self.ctx['build_from_packages']:
        return download_iex_packages(self, l1_threads_count, config_id)
    else:
        return download_iex_from_resources_and_svn(self, l1_threads_count, config_id)


def change_paths_in_confs(self, config_path, packages_dir, dicts_path, remorph_path, l1_threads_count=None):
    log_path = self.log_path('logiex.log')
    replace(config_path, 'syslog', log_path)
    replace(config_path, 'Pid', '#Pid')  # chtoby zapustit NE kak demon i videt vyvod v stdout, stderr
    if l1_threads_count:
        replace(config_path, 'L1ThreadsCount : 32', 'L1ThreadsCount : ' + str(l1_threads_count))

    prefix = [' ', '\t', '"']
    for p in prefix:
        replace(config_path, p + '/var/run', p + packages_dir)
        replace(config_path, p + '/usr/share/iex/grammars', p + dicts_path)
        replace(config_path, p + '/usr/share/iex', p + packages_dir)
        recursive_replace(packages_dir + '/settings', '*', p + '/usr/share/iex/remorph', p + remorph_path)
        recursive_replace(packages_dir + '/settings', '*.json', p + '/usr/share/iex/grammars', p + dicts_path)
        recursive_replace(packages_dir + '/settings', '*', p + '/usr/share/iex', p + packages_dir)
        recursive_replace(packages_dir, '*', p + '/usr/share/iex', p + packages_dir)

    logging.info('config: ' + read_text(config_path))


def change_paths_in_remorph_grammars(self, remorph_grammars_dir, file_mask):
    recursive_replace(remorph_grammars_dir, file_mask, '/usr/share/iex', self.abs_path())
