# coding: utf-8

from sandbox.sdk2.resource import AbstractResource
from sandbox.projects.resource_types import releasers as resource_releasers


# IndexNow Resources
class IndexNowRequestProcessor(AbstractResource):
    """
    Index now request_processor
    """
    arcadia_build_path = 'robot/samovar/index_now/request_processor/request_processor'
    releasable = True
    releasers = resource_releasers.samovar_releasers


class IndexNowServer(AbstractResource):
    """
    Index now server
    """
    arcadia_build_path = 'robot/samovar/index_now/http_server/server'
    releasable = True
    releasers = resource_releasers.samovar_releasers


class IndexNowConfigs(AbstractResource):
    """
    Index now configs
    """
    resource_file = "svn_configs.tar.gz"
    releasable = True
    releasers = resource_releasers.samovar_releasers
