import logging
from sandbox import sdk2
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.advq.common.parameters import YtParameters

import published_urls

logger = logging.getLogger(__name__)


class LcModerationTask(sdk2.Task):

    class Requirements(sdk2.Requirements):
        cores = 1
        environments = (
            PipEnvironment("yandex-yt"),
            PipEnvironment("psycopg2-binary"),
        )

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(YtParameters):
        lpc_psycopg2_connection_string_vault_user = sdk2.parameters.String(
            "psycopg2 connection string vault user",
            default="LPC",
        )
        lpc_psycopg2_connection_string_vault_name = sdk2.parameters.String(
            "psycopg2 connection string vault name",
            default="lpc-psycopg2-production",
        )
        constructor_token_vault_user = sdk2.parameters.String(
            "Constructor access token user name in vault",
            default="LPC",
        )
        constructor_token_vault_name = sdk2.parameters.String(
            "Constructor access token vault name",
            default="constructor_token",
        )
        dump_date = sdk2.parameters.String(
            "Date to dump pages at",
            default="",
        )

    def get_lpc_psycopg2_connection(self):
        if (
                self.Parameters.lpc_psycopg2_connection_string_vault_user
                and self.Parameters.lpc_psycopg2_connection_string_vault_name
        ):
            import psycopg2

            connection_string = str(sdk2.Vault.data(
                self.Parameters.lpc_psycopg2_connection_string_vault_user,
                self.Parameters.lpc_psycopg2_connection_string_vault_name,
            ))
            return psycopg2.connect(connection_string)
        else:
            return None

    def get_dump_date(self):
        return self.Parameters.dump_date

    def get_constructor_token(self):
        return sdk2.Vault.data(
            self.Parameters.constructor_token_vault_user,
            self.Parameters.constructor_token_vault_name,
        )

    def get_yt_token(self):
        return sdk2.Vault.data(
            self.Parameters.yt_token_vault_user,
            self.Parameters.yt_token_vault_name,
        )

    def on_execute(self):
        from yt import wrapper as yt

        connection = self.get_lpc_psycopg2_connection()
        yt_client = yt.YtClient(proxy=str(self.Parameters.yt_proxy), token=self.get_yt_token())

        if (connection is None):
            logger.info('Failed to connect. Quitting.')
            return

        published_urls.Job(connection, yt_client, self).on_execute()
