import logging
import requests
import time
from sandbox.projects.LandingConstructor.common.driver import YtDumpDriver, SchemaColumn
from datetime import date, timedelta

logger = logging.getLogger(__name__)


class Job(YtDumpDriver):
    def __init__(self, connection, yt_client, task):
        super(Job, self).__init__(connection, yt_client, task)

    def get_schema(self):
        return [
            SchemaColumn(schema={"name": "url", "type": "string"}),
            SchemaColumn(schema={"name": "landingId", "type": "int64"}),
            SchemaColumn(schema={"name": "clientId", "type": "string"}),
            SchemaColumn(schema={"name": "latestCreation", "type": "string"}),
            SchemaColumn(schema={"name": "pageContent", "type": "any"}),
        ]

    def get_date(self):
        yesterday = (date.today() - timedelta(days=1)).strftime('%Y-%m-%d')
        dump_date = self.get_task().get_dump_date()
        if not dump_date:
            dump_date = yesterday
        return dump_date

    def get_table(self):
        return '//home/lpc/moderation/{}'.format(self.get_date())

    def get_decomposed_page(self, landing_id, version):
        url = 'https://ad-constructor.yandex.ru/api/cpa-moderation-content/{}/{}'.format(landing_id, version)
        response = requests.get(url, headers={"authorization": self.get_task().get_constructor_token()})
        logger.info("Getting: {}, Status: {}".format(url, response.status_code))

        if response.status_code == 200:
            return response.json()["result"][0]["moderationInfo"]

        return None

    def prepareForTable(self, schema, rows):
        prepared_data = []
        for row in rows:
            prepared_row = {}
            for column in schema:
                prepared_row[column.name()] = column.transform(row, None)

            prepared_row["pageContent"] = self.get_decomposed_page(row[1], row[2])
            prepared_data.append(prepared_row)

        return prepared_data

    def fetch_data(self, connection):
        import psycopg2.extras

        cursor = connection.cursor(cursor_factory=psycopg2.extras.DictCursor)

        cursor.execute(
            """
                SELECT
                    'https://yandex.ru/turbo?text=lpc/' || "turboHash" AS "url",
                    max("landingId") AS "landingId",
                    max("version") AS "version",
                    max(path[1]) AS "clientId",
                    max("createdAt")::varchar AS "latestCreation"
                FROM pages_publishes
                WHERE
                    "createdAt"::date = %s
                    AND "deletedAt" IS NULL
                    AND "status" = 'success'
                GROUP BY "turboHash"
                ORDER BY "latestCreation"
            """,
            (self.get_date(),)
        )

        return cursor
