# -*- coding: utf-8 -*-

from sandbox.projects.LandingConstructor.common.driver import YtDumpDriver, SchemaColumn
import time
import datetime


class Job(YtDumpDriver):
    def __init__(self, connection, yt_client):
        super(Job, self).__init__(connection, yt_client)

    def get_schema(self):
        return [
            SchemaColumn(schema={"name": "ts", "type": "uint64"}),
            SchemaColumn(schema={"name": "date", "type": "string"}),
            SchemaColumn(schema={"name": "stat", "type": "string"}),
            SchemaColumn(schema={"name": "count", "type": "uint64"}),
        ]

    def should_append_table(self):
        return True

    def get_table(self):
        return '//home/lpc/stat/pages'

    def fetch_data(self, connection):
        cursor = connection.cursor()
        ts = int(time.time() * 1000)
        date = str(datetime.date.today())

        # создано
        cursor.execute("""
            SELECT COUNT(*) FROM nodes WHERE type = 'page' AND "deletedAt" IS NULL;
        """)
        created = cursor.fetchone()[0]

        # опубликовано
        cursor.execute("""
            SELECT COUNT (DISTINCT pp."nodeId") FROM pages_publishes pp
            JOIN page_versions pv ON pp."nodeId" = pv."nodeId" AND pp.version = pv.max_published_version
            WHERE pp.status = 'success';
        """)
        published = cursor.fetchone()[0]

        return [
            {'ts': ts, 'date': date, 'stat': 'created', 'count': created},
            {'ts': ts, 'date': date, 'stat': 'published', 'count': published},
        ]
