from sandbox.projects.LandingConstructor.common.driver import YtDumpDriver, SchemaColumn


class Job(YtDumpDriver):
    def __init__(self, connection, yt_client):
        super(Job, self).__init__(connection, yt_client)

    def get_schema(self):
        return [
            SchemaColumn(schema={"name": "date", "type": "string"}),
            SchemaColumn(schema={"name": "section", "type": "string"}),
            SchemaColumn(schema={"name": "count", "type": "uint64"}),
        ]

    def get_table(self):
        return '//home/lpc/stat/pages-with-section-by-date'

    def fetch_data(self, connection):
        import psycopg2.extras

        cursor = connection.cursor(cursor_factory=psycopg2.extras.DictCursor)

        cursor.execute("""
            WITH RECURSIVE sections_recursive(nodeId, version, data, date) AS (
                    SELECT
                            pv."nodeId",
                            pv.max_published_version,
                            pd.data,
                            pd."createdAt"::timestamp::date::varchar as date
                    FROM
                            page_versions pv
                    JOIN pages_data pd ON pv."nodeId" = pd."nodeId" AND pv.max_published_version = pd.version
                    WHERE
                            pv.max_published_version IS NOT NULL
                            AND pd."createdAt" > NOW() - INTERVAL '6 month'
                    UNION ALL
                            SELECT
                                    nodeId,
                                    version,
                                    jsonb_array_elements(data->'children') AS data,
                                    date
                    FROM sections_recursive
                    WHERE jsonb_typeof(data->'children') = 'array'
            )
            SELECT
                    date,
                    section,
                    count(*)
            FROM (
                    SELECT DISTINCT
                            nodeId,
                            version,
                            data->>'type' AS section,
                            date
                    FROM sections_recursive
                    WHERE data->'type' IS NOT NULL
            ) AS pages_with_section
            GROUP BY date, section;
        """)

        return cursor
