from sandbox.projects.LandingConstructor.common.driver import YtDumpDriver, SchemaColumn


class Job(YtDumpDriver):
    def __init__(self, connection, yt_client):
        super(Job, self).__init__(connection, yt_client)

    def get_schema(self):
        return [
            SchemaColumn(schema={"name": "date", "type": "string"}),
            SchemaColumn(schema={"name": "template", "type": "string"}),
            SchemaColumn(schema={"name": "count", "type": "uint64"}),
        ]

    def get_table(self):
        return '//home/lpc/stat/published-templates-by-date'

    def fetch_data(self, connection):
        import psycopg2.extras

        cursor = self.connection.cursor(cursor_factory=psycopg2.extras.DictCursor)

        cursor.execute("""
            SELECT
                pp."createdAt"::timestamp::date::varchar AS date,
                pd.data->>'_id' AS template,
                count(*)
            FROM pages_publishes pp
            JOIN page_versions pv ON pp."nodeId" = pv."nodeId" AND pp.version = pv.max_published_version
            JOIN pages_data pd ON pv."nodeId" = pd."nodeId" AND pv.max_published_version = pd.version
            WHERE
                pp."createdAt" > '2019-03-23'
                AND substring(pd.data->>'_id', '-(preset|wizard)$') IS NOT NULL
            GROUP BY date, template
            ORDER BY date desc;
        """)

        return cursor
