from sandbox.projects.LandingConstructor.common.driver import YtDumpDriver, SchemaColumn


class Job(YtDumpDriver):
    def __init__(self, connection, yt_client):
        super(Job, self).__init__(connection, yt_client)

    def get_schema(self):
        return [
            SchemaColumn(schema={"name": "template", "type": "string"}),
            SchemaColumn(schema={"name": "count", "type": "uint64"}),
        ]

    def get_table(self):
        return '//home/lpc/stat/published-templates-latest'

    def fetch_data(self, connection):
        import psycopg2.extras

        cursor = connection.cursor(cursor_factory=psycopg2.extras.DictCursor)

        cursor.execute("""
            SELECT
                count(*), pd.data->>'_id' AS template
            FROM page_versions pv
            JOIN pages_data pd ON pv."nodeId" = pd."nodeId" AND pv.max_published_version = pd.version
            WHERE
                substring(pd.data->>'_id', '-(preset|wizard)$') IS NOT NULL
                AND pd."createdAt" > '2019-03-23'
            GROUP BY template
            ORDER BY count desc;
        """)

        return cursor
