from sandbox.projects.LandingConstructor.common.driver import YtDumpDriver, SchemaColumn


class Job(YtDumpDriver):
    def __init__(self, connection, yt_client):
        super(Job, self).__init__(connection, yt_client)

    def get_schema(self):
        return [
            SchemaColumn(schema={"name": "date", "type": "string"}),
            SchemaColumn(schema={"name": "section", "type": "string"}),
            SchemaColumn(schema={"name": "count", "type": "uint64"}),
        ]

    def get_table(self):
        return '//home/lpc/stat/sections-by-date'

    def fetch_data(self, connection):
        import psycopg2.extras

        cursor = connection.cursor(cursor_factory=psycopg2.extras.DictCursor)

        cursor.execute("""
            WITH RECURSIVE sections_recursive(data, date, level) AS (
                    SELECT data,
                           "createdAt"::timestamp::date::varchar as date,
                           1 AS level
                    FROM pages_data pd
                    INNER JOIN page_versions pv
                        ON pd."nodeId" = pv."nodeId"
                        AND pd.version = pv.max_published_version
                    WHERE pd."createdAt" > NOW() - INTERVAL '6 month'
                UNION ALL
                    SELECT jsonb_array_elements(data->'children') AS data,
                           date,
                           level + 1 AS level
                    FROM sections_recursive
                    WHERE jsonb_typeof(data->'children') = 'array'
            )
            SELECT date, data->>'type' as section,
                   COUNT(*) as count
            FROM sections_recursive
            WHERE data->'type' IS NOT NULL
            GROUP BY date, data->>'type'
            ORDER BY date ASC;
        """)

        return cursor
