# -*- coding: utf-8 -*-

from sandbox.projects.LandingConstructor.common.driver import YtDumpDriver, SchemaColumn
import time
import datetime


class Job(YtDumpDriver):
    def __init__(self, connection, yt_client):
        super(Job, self).__init__(connection, yt_client)

    def get_schema(self):
        return [
            SchemaColumn(schema={"name": "ts", "type": "uint64"}),
            SchemaColumn(schema={"name": "date", "type": "string"}),
            SchemaColumn(schema={"name": "stat", "type": "string"}),
            SchemaColumn(schema={"name": "count", "type": "uint64"}),
        ]

    def should_append_table(self):
        return True

    def get_table(self):
        return '//home/lpc/stat/sites'

    def fetch_data(self, connection):
        cursor = connection.cursor()
        ts = int(time.time() * 1000)
        date = str(datetime.date.today())

        # сайтов создано
        cursor.execute("""
            SELECT count("siteNodeId") FROM sites_data;
        """)
        created = cursor.fetchone()[0]

        # сайтов опубликовано (>1 опубликованной страницы)
        cursor.execute("""
            SELECT count(distinct sd."siteNodeId") FROM sites_data sd
            JOIN page_urls_actual pua ON sd."siteNodeId" = pua."siteNodeId";
        """)
        published = cursor.fetchone()[0]

        # сайтов с кастомным доменом создано
        cursor.execute("""
            SELECT count(distinct sd."siteNodeId") FROM sites_data sd
            JOIN domains d ON d."nodeId" = sd."siteNodeId"
            WHERE d.domain NOT SIMILAR TO 'project\d+\.turbo\.site';
        """)
        domains_created = cursor.fetchone()[0]

        # сайтов с кастомным доменом опубликовано
        cursor.execute("""
            SELECT count(distinct sd."siteNodeId") FROM sites_data sd
            JOIN domains d ON d."nodeId" = sd."siteNodeId"
            JOIN page_urls_actual pua ON sd."siteNodeId" = pua."siteNodeId"
            WHERE d.domain NOT SIMILAR TO 'project\d+\.turbo\.site';
        """)
        domains_published = cursor.fetchone()[0]

        # сайтов cо справочником создано
        cursor.execute("""
            SELECT count("siteNodeId") FROM sites_data
            WHERE data->'organization'->>'id' IS NOT NULL;
        """)
        sprav_created = cursor.fetchone()[0]

        # сайтов cо справочником опубликовано
        cursor.execute("""
            SELECT count(distinct sd."siteNodeId") FROM sites_data sd
            JOIN page_urls_actual pua ON sd."siteNodeId" = pua."siteNodeId"
            WHERE sd.data->'organization'->>'id' IS NOT NULL;
        """)
        sprav_published = cursor.fetchone()[0]

        # сайтов с >1 страницей создано
        cursor.execute("""
            SELECT COUNT(*) FROM (
                SELECT 1 FROM sites_data sd
                JOIN nodes n1 ON sd."siteNodeId" = n1.id
                JOIN nodes n2 ON n2.path[1] = n1.path[1] AND n2.path @> (n1.path || n1.name) AND
                    n2.type = 'page' AND n2."deletedAt" IS NULL
                GROUP BY sd."siteNodeId" HAVING COUNT(*) > 1
            ) AS t;
        """)
        more_1_page_created = cursor.fetchone()[0]

        # сайтов с >1 страницей опубликовано
        cursor.execute("""
            SELECT COUNT(*) FROM (
                SELECT 1 FROM sites_data sd
                JOIN page_urls_actual pua ON sd."siteNodeId" = pua."siteNodeId"
                GROUP BY sd."siteNodeId" HAVING COUNT(*) > 1
            ) AS t;
        """)
        more_1_page_published = cursor.fetchone()[0]

        return [
            {'ts': ts, 'date': date, 'stat': 'created', 'count': created},
            {'ts': ts, 'date': date, 'stat': 'published', 'count': published},
            {'ts': ts, 'date': date, 'stat': 'domains_created', 'count': domains_created},
            {'ts': ts, 'date': date, 'stat': 'domains_published', 'count': domains_published},
            {'ts': ts, 'date': date, 'stat': 'sprav_created', 'count': sprav_created},
            {'ts': ts, 'date': date, 'stat': 'sprav_published', 'count': sprav_published},
            {'ts': ts, 'date': date, 'stat': 'more_1_page_created', 'count': more_1_page_created},
            {'ts': ts, 'date': date, 'stat': 'more_1_page_published', 'count': more_1_page_published},
        ]
