from sandbox.projects.LandingConstructor.common.driver import YtDumpDriver, SchemaColumn


class Job(YtDumpDriver):
    def __init__(self, connection, yt_client):
        super(Job, self).__init__(connection, yt_client)

    def get_schema(self):
        return [
            SchemaColumn(schema={"name": "date", "type": "string"}),
            SchemaColumn(schema={"name": "template", "type": "string"}),
            SchemaColumn(schema={"name": "count", "type": "uint64"}),
        ]

    def get_table(self):
        return '//home/lpc/stat/templates-by-date'

    def fetch_data(self, connection):
        import psycopg2.extras

        cursor = connection.cursor(cursor_factory=psycopg2.extras.DictCursor)

        cursor.execute("""
            SELECT
                "createdAt"::timestamp::date::varchar AS date,
                data->>'_id' AS template,
                count(*)
            FROM pages_data
            WHERE
                substring(data->>'_id', '-(preset|wizard)$') IS NOT NULL
                AND "createdAt" > '2019-03-23'
                AND version = 1
            GROUP BY date, template
            ORDER BY date
        """)

        return cursor
