import yt.wrapper as yt


def filtered(iter, fn):
    return (x for x in iter if fn(x))


class Dumper(object):
    def __init__(self, yt_token, yt_server, yt_tables, batch_size=1000, rows_range=None):
        self.yt_token = yt_token
        self.yt_server = yt_server
        self.yt_tables = yt_tables
        self.batch_size = batch_size
        self.rows_range = rows_range

    def run(self):
        for table in self.yt_tables:
            rows = self.fetch_rows(table, self.rows_range)
            self.dump_in_batch(rows, self.batch_size)

    def fetch_rows(self, table_name, range=None):
        client = yt.YtClient(proxy=self.yt_server, token=self.yt_token)

        table = yt.TablePath(
            table_name,
            columns=["Url", "Result", "Error"],
            start_index=range[0] if range else None,
            end_index=range[1] if range else None,
        )

        return filtered(client.read_table(table), self.filter)

    def filter(self, row):
        pass

    def dump_in_batch(self, rows, size):
        batch = []

        for row in rows:
            batch.append(row)

            if len(batch) == size:
                self.dump(batch)
                batch = []

        if len(batch) > 0:
            self.dump(batch)

    def dump(self, rows):
        pass
