# coding: utf-8
import json

from sandbox import common
from sandbox.sandboxsdk.parameters import SandboxStringParameter
import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task


class CommintRevision(SandboxStringParameter):
    name = 'commit_revision'
    description = 'Commit revision'
    default_value = ''


class CommintAuthor(SandboxStringParameter):
    name = 'commit_author'
    description = 'Commit author'
    default_value = ''


class Task(sdk_task.SandboxTask):
    """Запускаем задачи для балансеров из RuntimeCloud"""

    type = 'LAUNCH_RUNTIME_CLOUD_BALANCER_TASKS'
    execution_space = 512
    required_ram = 1024
    input_parameters = [CommintRevision, CommintAuthor]

    def on_execute(self):
        monitoring_root = sdk_svn.Arcadia.get_arcadia_src_dir(
            'arcadia:/arc/trunk/arcadia/infra/awacs/templates/aux-balancers-data/@{}'.format(
                self.ctx['commit_revision']
            )
        )
        with open('{}/data.json'.format(monitoring_root)) as ifile:
            try:
                json.load(ifile)
            except ValueError as err:
                raise common.errors.TaskFailure(
                    'Invalid "data.json".\n\tcommit: https://a.yandex-team.ru/commit/{} by {}\n\n\t{}'.format(
                        self.ctx['commit_revision'],
                        self.ctx['commit_author'],
                        err
                    )
                )

        its_handlers = self.create_subtask(
            task_type='BUILD_BALANCER_ITS_HANDLERS',
            inherit_notifications=True,
            input_parameters={
                'commit_revision': self.ctx['commit_revision'],
            },
            description='Генерируем its-ручки для балансеров'
        )
        self.info = "Subtask for its handlers: {}\n\n".format(its_handlers.id)

        tc_dashboards = self.create_subtask(
            task_type='BUILD_BALANCER_NANNY_TRAFFIC_CONTROL_DASHBOARDS',
            inherit_notifications=True,
            input_parameters={
                'commit_revision': self.ctx['commit_revision'],
            },
            description='Генерируем дашборды управления трафиком для балансеров'
        )
        self.info = "Subtask for traffic control dashboards: {}\n\n".format(tc_dashboards.id)


__Task__ = Task
