from sandbox import sdk2

from sandbox.projects.Lighthouse.base import LighthouseBase, LighthouseReport


class RunLighthouseBulk(LighthouseBase):
    """
    Run lighthouse bulk test
    """

    class Parameters(LighthouseBase.Parameters):
        urls = sdk2.parameters.String('URLs', multiline=True)

    def on_execute(self):
        urls = self.Parameters.urls.split('\n')

        for index, url in enumerate(urls):
            self.run_test('report-{}'.format(index), url)

    @property
    def footer(self):
        def serialize(resource):
            return {
                'URL': '<a href="{}">{}</a>'.format(resource.target, resource.target),
                'Report': '<a href="https://proxy.sandbox.yandex-team.ru/{}/result.report.dom.html">report</a>'.format(
                    str(resource.id)
                )
            }

        resources = sdk2.Resource.find(
            resource_type=LighthouseReport,
            state='READY',
            task=self
        )

        return [{
            'helperName': '',
            'content': {
                '<h3>Report</h3>': [serialize(resource) for resource in resources.limit(20)]
            }
        }]
