import json
import os

from sandbox import sdk2

import sandbox.common.types.misc as ctm
from sandbox.projects.sandbox import LXC_CONTAINER
from sandbox.sandboxsdk.process import run_process


class LighthouseReport(sdk2.Resource):
    """
    Lighthouse report
    """
    target = sdk2.parameters.String('URL')
    # scores = sdk2.parameters.Dict('Scores')
    # metrics = sdk2.parameters.Dict('Metrics')


class LighthouseContainer(LXC_CONTAINER):
    """
    Lighthouse LXC container
    """
    pass


class LighthouseBase(sdk2.Task):
    """
    Run lighthouse test
    """

    class Requirements(sdk2.Requirements):
        disk_space = 1200
        dns = ctm.DnsType.DNS64
        ram = 4096

    class Parameters(sdk2.Parameters):
        _container = sdk2.parameters.Container(
            'Lighthouse environment',
            # type=LighthouseContainer,  # FIXME: invalid argument (SANDBOX-6404)
            default_value=274035956,  # https://sandbox.yandex-team.ru/resource/274035956/view
            required=True
        )

    def mkdir(self, name):
        os.mkdir(name, 0o755)

        return name

    def run_test(self, report_dir, url):
        self.mkdir(report_dir)

        task_dir = os.path.dirname(os.path.realpath(__file__))
        script = os.path.join(task_dir, 'lighthouse.sh')
        scores = {}
        metrics = {}

        run_process(
            ['sh', script, report_dir, url],
            shell=True,
            log_prefix='lighthouse'
        )

        with open(os.path.join(report_dir, 'result.report.json')) as json_data:
            result = json.load(json_data)

            for aggregation in result['aggregations']:
                scores[aggregation['name']] = aggregation['total']

            for key in result['audits']:
                metrics[key] = result['audits'][key]['rawValue']

        report = sdk2.ResourceData(LighthouseReport(
            self, 'Lighthouse report for ({})'.format(url), report_dir, target=url
        ))

        report.ready()

        return report
