#!/bin/sh

mkdir -p $1

rm -rf $HOME/.pki/nssdb
mkdir -p $HOME/.pki/nssdb
certutil -d $HOME/.pki/nssdb -N --empty-password

if [ ! -f all.pem ]
then
    curl https://crls.yandex.net/allCAs.pem > all.pem
fi

certutil -d sql:$HOME/.pki/nssdb -A -t TC -n "yandex.ru" -i all.pem

lighthouse \
    --chrome-flags='--headless --disable-gpu --disable-default-apps --disable-account-consistency --disable-cloud-import --disable-sync --ignore-certificate-errors' \
    --save-assets \
    --save-artifacts \
    --output=json \
    --output=html \
    --output=domhtml \
    --output-path=$1/result.json $2
