# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters

# import collections


class Task(sdk_task.SandboxTask):
    """ Make a Fml Conveyor FORMULA_COMMIT report (FORMULATOR-1483). """

    class FmlTokenName(sdk_parameters.SandboxStringParameter):
        name = "fml_token"
        description = "Vault with Fml Token"

    type = "MAKE_CONVEYOR_FML_PROCESS_TEMPLATES_LIST_REPORT"
    input_parameters = [FmlTokenName]

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import get_file
        import get_file_strategy
        get_file_strategy = get_file_strategy.return_get_file_class(get_file.GetFile)
        import fml_helper

        fml_token = self.get_vault_data(self.ctx[self.FmlTokenName.name])

        fml_helper_ctx = fml_helper.FMLHelper(get_file_strategy, fml_token)

        fml_conveyor_setup = fml_helper_ctx.FMLConveyorSetupFactory()

        result = []
        pt_2_wfid = {}
        for n, af in enumerate(fml_conveyor_setup.fml_xml_conveyor_page.GenWebProcessTemplateResultsAutoFormulas(), 1):
            pt_id = fml_helper_ctx.ProcessTemplateResultAutoformulaWrapper(af).GetFmlProcessTemplateId()
            pt_url = fml_helper_ctx.ProcessTemplateResultAutoformulaWrapper(af).GetFmlProgessTemplateUrl()
            result.append(" ".join([
                "  {0}.".format(n),
                "https://fml.yandex-team.ru/conveyor/setup#formula{0}".format(af.GetId()),
                af.GetSearchType(),
                af.GetType(),
                af.GetRankingModel(),
                str(pt_id),
                pt_url,
                "autoformula's author staff::{0}".format(af.GetAttributesDict()['owner'])]))
            fml_process = fml_helper_ctx.FMLProcessFactory(pt_id)
            wfid = fml_process.fml_xml_process_page.process_template.AsFMLProcessTemplateNirvanaProcess(fml_helper_ctx).GetWfId()
            result.append("    * https://nirvana.yandex-team.ru/flow/{0}".format(wfid))
            pt_2_wfid[pt_id] = wfid

        with open('report.st', 'wt') as resource_file:
            resource_file.write("\n".join(result))

        self.create_resource("Fml Conveyor fml process template list report", 'report.st', 'FML_CONVEYOR_FML_PROCESS_TEMPLATES_LIST_REPORT')

        logging.info("Resource FML_CONVEYOR_FORMULA_COMMIT_REPORT should be created")


__Task__ = Task
