# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters

import collections


class OperationBlock(object):
    def __init__(self, block_info):
        print '1'
        assert(block_info['type'] == 'operation')
        self.block_code = block_info['blockCode']
        # self.block_guid = block_info['blockGuid']
        self.name = block_info['name']
        self.op_id = block_info['operationId']

    def AddParameters(self, api):
        black_list = set(
            [
                'job-command',
                'job-binary-url',
                'slave-job-command',
                'slave-job-binary-url',
                'master-job-command',
                'master-job-binary-url',
            ])
        self.params = collections.OrderedDict()
        rslt = api.GetBlockParametersByCode(self.block_code)['result'][0]['parameters']
        for param in sorted(rslt):
            if 'value' in param:
                param_type = type(param['value'])
                value = param['value']
                name = param['parameter']
                if name not in black_list:
                    self.params[name] = {
                        'value': value,
                        'type': repr(param_type)
                    }
        pass

    def GetCode(self):
        return self.block_code

    def GetJSON(self):
        rslt = collections.OrderedDict()
        rslt['block_code'] = self.block_code
        rslt['name'] = self.name
        rslt['op_id'] = self.op_id
        rslt['params'] = self.params
        return rslt


class OperationConnection(object):
    def __init__(self, conn_info):
        assert(conn_info['@type'] == 'OperationConnectionInfo')
        self.dest_block_code = conn_info['destBlockCode']
        self.dest_endpiont_name = conn_info['destEndpointName']
        self.src_block_code = conn_info['sourceBlockCode']
        self.src_endpiont_name = conn_info['sourceEndpointName']

    def GetJSON(self):
        rslt = collections.OrderedDict()
        rslt['dest_block_code'] = self.dest_block_code
        rslt['dest_endpiont_name'] = self.dest_endpiont_name
        rslt['src_block_code'] = self.src_block_code
        rslt['src_endpiont_name'] = self.src_endpiont_name
        return rslt


class NirvanaDumper(object):
    def __init__(self, wfid, nv_token, algorc_nirvana_api):
        self.wfid = wfid
        self.nv_token = nv_token
        self.api = algorc_nirvana_api.NirvanaAPI(self.wfid, self.nv_token)

        self.Parse()

    def Parse(self):
        rslt = self.api.GetWorkflow()
        self.op_blocks = {}
        for block_info in rslt['result']['blocks']:
            if block_info['type'] == 'operation':
                op_block = OperationBlock(block_info)
                op_block.AddParameters(self.api)
                self.op_blocks[op_block.GetCode()] = op_block
            else:
                print block_info

        self.conns_info = []
        for conn_info in rslt['result']['connections']:
            if conn_info['@type'] == 'OperationConnectionInfo':
                op_conn = OperationConnection(conn_info)
                self.conns_info.append(op_conn)
            else:
                print conn_info

    def Dump(self):
        json_dump = collections.OrderedDict()
        json_dump['blocks'] = {}
        for block_code in self.op_blocks:
            json_dump['blocks'][block_code] = self.op_blocks[block_code].GetJSON()
        json_dump['connectons'] = []
        for conn in self.conns_info:
            json_dump['connectons'].append(conn.GetJSON())
        return json_dump


class Task(sdk_task.SandboxTask):
    """ Make a Fml Conveyor FORMULA_COMMIT report (FORMULATOR-1483). """

    class FmlTokenName(sdk_parameters.SandboxStringParameter):
        name = "fml_token"
        description = "Vault with Fml Token"

    class LowestConveyorId(sdk_parameters.SandboxIntegerParameter):
        name = "lowest_conveyor_id"
        description = "Lowest Fml Conveyor Id for processing"
        default_value = 1394

    class UpperConveyorId(sdk_parameters.SandboxIntegerParameter):
        name = "upper_conveyor_id"
        description = "Upper Fml Conveyor Id for processing"
        default_value = 1394

    type = "MAKE_FML_CONVEYOR_FORMULA_COMMIT_REPORT"
    input_parameters = [FmlTokenName, LowestConveyorId, UpperConveyorId]

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import get_file
        import get_file_strategy
        get_file_strategy = get_file_strategy.return_get_file_class(get_file.GetFile)
        import fml_helper

        fml_token = self.get_vault_data(self.ctx[self.FmlTokenName.name])

        fml_helper_ctx = fml_helper.FMLHelper(get_file_strategy, fml_token)

        def LoadConveyorsData(fml_helper):
            conveyors_id = fml_helper_ctx.LoadConveyorsByLowerIdBound(
                self.ctx[self.LowestConveyorId.name],
                self.ctx[self.UpperConveyorId.name])
            logging.info("Loaded {0}".format(conveyors_id))

        LoadConveyorsData(fml_helper_ctx)

        with open('report.json', 'wt') as resource_file:
            resource_file.write(fml_helper.make_formulator_1483_report(fml_helper_ctx, apply_df=True))

        self.create_resource("Fml Conveyor FORMULA_COMMIT report", 'report.json', 'FML_CONVEYOR_FORMULA_COMMIT_REPORT')

        logging.info("Resource FML_CONVEYOR_FORMULA_COMMIT_REPORT should be created")

        with open('ext_report.json', 'wt') as resource_file:
            resource_file.write(fml_helper.make_formulator_1483_report(fml_helper_ctx, apply_df=True, short=False))

        self.create_resource("Fml Conveyor FORMULA_COMMIT extended report", 'ext_report.json', 'FML_CONVEYOR_FORMULA_COMMIT_REPORT_EXTENDED')

        logging.info("Resource FML_CONVEYOR_FORMULA_COMMIT_REPORT_EXTENDED should be created")


__Task__ = Task
