# -*- coding: utf-8 -*-

from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk.channel import channel
from sandbox.projects import resource_types
from sandbox.projects.common.build.CommonBuildTask import CommonBuildTask


class MakeGeodbData(CommonBuildTask):
    type = 'MAKE_GEODB_DATA'

    TARGET_RESOURCES = (
        (resource_types.GEODB_BUILDER_EXECUTABLE, 'tools/geodb_builder/geodb_builder'),
    )

    def on_enqueue(self, *args, **kwargs):
        CommonBuildTask.on_enqueue(self, *args, **kwargs)
        proto = self.create_resource(
            self.descr, 'geodb_proto_data',
            resource_types.GEODB_DATA
        )
        self.ctx['geodb_proto_data'] = proto.id

        json = self.create_resource(
            self.descr, 'geodb_json_data',
            resource_types.UNKNOWN_RESOURCE
        )
        self.ctx['geodb_json_data'] = json.id

    def do_execute(self):
        CommonBuildTask.do_execute(self)
        binary = channel.sandbox.get_resource(self.get_prepared_resource_id('geodb_builder')).path
        proto_out = channel.sandbox.get_resource(self.ctx['geodb_proto_data']).path
        json_out = channel.sandbox.get_resource(self.ctx['geodb_json_data']).path
        run_process([binary, 'remote', '-v', '-o', proto_out, '--as-json', json_out], check=False, outputs_to_one_file=False)

    def arcadia_info(self):
        return None, 'nobranch', None


__Task__ = MakeGeodbData
