import logging

from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.sandboxsdk.errors import SandboxTaskFailureError


class MakeNewPersonalResource(SandboxTask):
    """
        Runs subtask that makes new sandbox resource from existing one and
        then releases that task. For Nanny integration
    """

    type = 'MAKE_NEW_PERSONAL_RESOURCE'

    execution_space = 10000

    class ResourceId(SandboxStringParameter):
        name = 'id'
        description = 'Resource id to copy'
        required = True

    input_parameters = [
        ResourceId
    ]

    def on_execute(self):
        if 'release_task_id' not in self.ctx:
            subtask = self.create_subtask(
                'MAKE_NEW_PERSONAL_RESOURCE_SUBTASK',
                description=self.description,
                input_parameters=self.ctx
            )
            self.ctx['release_task_id'] = subtask.id
            self.wait_task_completed(subtask.id)
        else:
            logging.info("creating release")
            release = self.create_release(
                self.ctx['release_task_id'],
                status='testing',
                subject='release for personal project',
                comments='comment: testing'
            )

        if not release:
            raise SandboxTaskFailureError('Cannot release task')


__Task__ = MakeNewPersonalResource
