import os
import logging

from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.parameters import SandboxStringParameter
from sandbox.sandboxsdk.task import SandboxTask
from sandbox.projects.MakePersonalBundle import PERSONAL_SEARCH_DAEMON_RELEASABLE

from sandbox.projects.common.nanny import nanny


class MakeNewPersonalResourceSubtask(nanny.ReleaseToNannyTask, SandboxTask):
    """
        Makes new sandbox resource from existing one. For Nanny integration
    """

    type = 'MAKE_NEW_PERSONAL_RESOURCE_SUBTASK'

    execution_space = 10000

    class ResourceId(SandboxStringParameter):
        name = 'id'
        description = 'Resource id to copy'
        required = True

    input_parameters = [
        ResourceId
    ]

    def on_execute(self):
        task_dir = os.getcwd()
        resource_id = self.ctx.get(self.ResourceId.name)
        logging.info("Resource id is " + resource_id)
        resource = channel.sandbox.get_resource(resource_id)
        if resource is not None:
            logging.info("resource is not None")
            resource_path = self.sync_resource(resource)
            logging.info("res_path = " + resource_path)

            self._subprocess(
                "cp " + resource_path + " " + task_dir,
                wait=True,
                shell=True,
                out_file_name="copy.out",
                log_prefix="copy"
            )
            self.set_info('Creating sandbox resource')
            self.create_resource(
                description='Bundle for resource',
                resource_path=task_dir + "/" + os.path.basename(resource_path),
                resource_type=PERSONAL_SEARCH_DAEMON_RELEASABLE,
                arch='any',
                attributes=dict(
                    ttl='inf',
                )
            )
            self.set_info('Done.')

        else:
            logging.info("resource is None")

    def on_release(self, additional_parameters):
        logging.info("in on_release()")
        self.set_info('Releasing resource')
        nanny.ReleaseToNannyTask.on_release(self, additional_parameters)
        SandboxTask.on_release(self, additional_parameters)


__Task__ = MakeNewPersonalResourceSubtask
