# coding=utf-8

import sys
import logging

import sandbox.sandboxsdk.svn as sdk_svn
import sandbox.sandboxsdk.task as sdk_task
import sandbox.sandboxsdk.parameters as sdk_parameters


class Task(sdk_task.SandboxTask):
    """ An empty task, which does nothing except of greets you. """

    class TokenName(sdk_parameters.SandboxStringParameter):
        name = "nirvana_token"
        description = "Vault with Nirvana Token"

    class Wfid(sdk_parameters.SandboxStringParameter):
        name = "wfid"
        description = "Nirvana workflow id"

    type = "MAKE_NIRVANA_WORKFLOW_SNAPSHOT"
    input_parameters = [TokenName, Wfid]

    def on_execute(self):
        sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/relev_tools/conveyor_dashboard/commons"))
        import nirvana_api
        import nirvana_workflow_helper

        # sys.path.append(sdk_svn.Arcadia.get_arcadia_src_dir("arcadia:/arc/trunk/arcadia/quality/nirvana_tools/workflow_dump_to_json"))
        # import workflow_dump_to_json

        logging.info("Hello, %s!", self.ctx.get(self.TokenName.name) or "Anonymous")
        # logging.info(self.get_vault_data('algorc_nirvana_token'))

        # api = nirvana_api.NirvanaAPI('foo', self.get_vault_data('algorc_nirvana_token'))

        # result = api.FindDataByPattern('job_binary_url_for_train_matrixnet_on_cpu_with_mtrixnet_rev_', 0, 0)
        dumper = nirvana_workflow_helper.NirvanaDumper(self.ctx[self.Wfid.name], self.get_vault_data('algorc_nirvana_token'))

        with open('workflow.json', 'wt') as resource_file:
            resource_file.write(nirvana_api.enc.encode(dumper.Dump()))

        self.create_resource("unofficial json with Nirvana Workflow structure", 'workflow.json', 'NIRVANA_WORKFLOW_SNAPSHOT')

        logging.info("Resource NIRVANA_WORKFLOW_SNAPSHOT should be created")


__Task__ = Task
