# coding: utf-8


from sandbox.projects import resource_types
from sandbox.projects.MarketCatalogerShooter import MarketCatalogerShooter, GraphiteHost, DebugMode

from sandbox.sandboxsdk.parameters import ResourceSelector


class BukerBin(ResourceSelector):
    name = 'buker_bin'
    description = 'Buker binary. Empty to build from trunk'
    resource_type = resource_types.MARKET_BUKER_BIN
    required = False


class BukerData(ResourceSelector):
    name = 'buker_data'
    description = 'Buker data. Empty to auto-find'
    resource_type = resource_types.MARKET_BUKER_DATA
    required = False


class BukerRequests(ResourceSelector):
    name = 'buker_requests'
    description = 'Buker requests'
    resource_type = resource_types.PLAIN_TEXT_QUERIES
    default_value = 190921798  # grepped from logs
    required = True


class MarketBukerShooter(MarketCatalogerShooter):
    """
        Таск приемки букера на производительность
    """
    type = 'MARKET_BUKER_SHOOTER'

    input_parameters = (
        BukerBin,
        BukerData,
        BukerRequests,
        GraphiteHost,
        DebugMode
    )

    binary_type = resource_types.MARKET_BUKER_BIN
    data_type = resource_types.MARKET_BUKER_DATA
    binary_build_task_type = 'BUILD_MARKET_BUKER_BIN'
    daemon_name = 'buker'

    binary_ctx_name = BukerBin.name
    data_ctx_name = BukerData.name
    reqs_ctx_name = BukerRequests.name

    reqs_limit = 500000

    @staticmethod
    def generate_config(data_path):
        tpl = """DATA_PATH                   {data}
MODELS_DATA_FILENAME        hyper_id_data.csv
CARDS_DATA_FILENAME         big_guru_card.data
CARDS_INDEX_FILENAME        big_guru_card.index.csv
MICRO_CARDS_DATA_FILENAME   small_guru_card.data
MICRO_CARDS_INDEX_FILENAME  small_guru_card.index.csv
COLLECTIONS_DIR {data}"""
        return tpl.format(data=data_path)


__Task__ = MarketBukerShooter
