# coding: utf-8


from sandbox.projects import resource_types
from sandbox.projects.MarketCatalogerShooter import MarketCatalogerShooter, GraphiteHost, DebugMode

from sandbox.sandboxsdk.parameters import ResourceSelector


class GuruBin(ResourceSelector):
    name = 'guru_bin'
    description = 'Guru binary. Empty to build from trunk'
    resource_type = resource_types.MARKET_GURU_BIN
    required = False


class GuruData(ResourceSelector):
    name = 'guru_data'
    description = 'Guru data. Empty to auto-find'
    resource_type = resource_types.MARKET_GURU_DATA
    required = False


class GuruRequests(ResourceSelector):
    name = 'guru_requests'
    description = 'Guru requests'
    resource_type = resource_types.PLAIN_TEXT_QUERIES
    default_value = 195879464  # grepped from logs
    required = True


class MarketGuruShooter(MarketCatalogerShooter):
    """
        Таск приемки букера на производительность
    """
    type = 'MARKET_GURU_SHOOTER'

    input_parameters = (
        GuruBin,
        GuruData,
        GuruRequests,
        GraphiteHost,
        DebugMode
    )

    binary_type = resource_types.MARKET_GURU_BIN
    data_type = resource_types.MARKET_GURU_DATA
    binary_build_task_type = 'BUILD_MARKET_GURU_BIN'
    daemon_name = 'guru'

    binary_ctx_name = GuruBin.name
    data_ctx_name = GuruData.name
    reqs_ctx_name = GuruRequests.name

    reqs_limit = 15000
    time_to_start = 600
    total_sessions = 3

    @staticmethod
    def generate_config(data_path):
        tpl = """# data from guruai and gurudata
DATADIR {data}/gurudaemon/gurudata
# data from indexer
REGION_INFO_PATH {data}/market/model_region_stats.mmap
REGION_INFO_UPDATE_PATH {data}/market/qstats/model_region_stats.update.mmap.gz
GROUP_REGION_INFO_PATH {data}/market/group_region_stats.mmap
GROUP_REGION_INFO_UPDATE_PATH {data}/market/qstats/group_region_stats.update.mmap.gz
REGION_TREE_PATH {data}/market/cataloger/geo.c2p
CLICKS_FILE      {data}/market/model-clicks.txt
CURRENCY_RATES_FILE {data}/market/currency_rates.xml
VENDORS_FILE {data}/gurudaemon/guru.global.vendors.xml
CATALOG_FILE {data}/gurudaemon/guru.catalog.xml
PARAMS_IDS_MAP_FILE {data}/gurudaemon/mbo_id_to_guru_id.json

# recommender
YAMAREC_DIR {data}/market/yamarec
RECOMENDED_MODELS_MIN_NUM 2
RECOMENDED_ACCESSORIES_MIN_NUM 5
RECOMENDED_MAX_NUM  20

# filter
USE_NEW_ENUM_IDS 1
# misc
XML_VERSION 3
root_model_id 8794
CATALOGER_TREE 1

NUMBER_TOP_CATEGORIES 5
NUMBER_MOBILE_TOP_CATEGORIES 5
NUMBER_TOP_VENDORS 3
NUMBER_MOBILE_TOP_VENDORS 5
NUMBER_TOP_MODELS 5


CATEGORY_RESTRICTIONS {data}/market/category-restrictions.pb

PRODUCTION 1"""
        return tpl.format(data=data_path)


__Task__ = MarketGuruShooter
