import functools
import time


class Limiter(object):
    def __init__(self, rps, seconds_in_batch):
        self.rps = rps
        self.seconds_in_batch = seconds_in_batch
        self.check_rate = rps * self.seconds_in_batch

    def init_batch(self):
        self.batch_start_time = time.time()
        self.current_batch_count = 0

    def check_rps(self):
        if self.current_batch_count >= self.check_rate:
            check_time = time.time()
            delay = self.batch_start_time + self.seconds_in_batch - check_time
            if delay > 0:
                time.sleep(delay)
            self.init_batch()
        self.current_batch_count += 1

    def __call__(self, func):
        self.init_batch()

        @functools.wraps(func)
        def wrapped(*args, **kwargs):
            self.check_rps()
            return func(*args, **kwargs)

        return wrapped


def limit(rps, seconds_in_batch):
    def decorator(func):
        limiter = Limiter(rps, seconds_in_batch)
        return limiter(func)

    return decorator
