import time
import requests

from limiter import limit


def get_request_handler(rps, seconds_in_batch):
    class RequestsHandler(object):
        def __init__(self, origin, **base_params):
            self.origin = origin
            self.base_params = base_params
            self.get_count = 0

        @limit(rps, seconds_in_batch)
        def get(self, params):
            self.get_count += 1
            return requests.get(
                self.origin,
                params=params,
            )

        def get_docids(self, params):
            try:
                r = self.get(params).json()
                return [doc[0] for doc in r[self.base_params['json_dump']][0]]
            except KeyError:
                return None
            except requests.exceptions.ConnectionError:
                time.sleep(0.05)
                return None

        def get_docids_retry(self, text, geoid, retry=3, sleep=1, sleep_retry=2):
            request_params = self.base_params.copy()
            request_params.update(
                text=text,
                lr=geoid,
            )
            for i in range(sleep_retry):
                if i != 0:
                    time.sleep(sleep)
                for j in range(retry):
                    r = self.get_docids(request_params)
                    if r is not None:
                        return r

    return RequestsHandler
