import sandbox.sdk2 as sdk2

import sandbox.sandboxsdk.environments as environments
import sandbox.common.errors as errors

from sandbox.projects.MarketModelWizard.GetGuruModels.yql_queries import get_models

yt_host_to_market_indexer = {
    'hahn': 'stratocaster',
    'banach': 'gibson',
}


class MarketModelWizardGetGuruModels(sdk2.Task):
    """Get guru models from market"""

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('YT parameters') as yt_parameters:
            yql_vault_token = sdk2.parameters.String(
                'Your yql token name in vault',
                default='YQL_TOKEN',
                required=True
            )

            with sdk2.parameters.RadioGroup('Yt host') as yt_host:
                yt_host.values['hahn'] = yt_host.Value(value='Hahn', default=True)
                yt_host.values['banach'] = yt_host.Value(value='Banach')

            output_table = sdk2.parameters.String(
                'Result output table',
                required=True,
            )

    class Requirements(sdk2.Task.Requirements):
        cores = 1

        environments = [
            environments.PipEnvironment('yql'),
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        from yql.api.v1.client import YqlClient

        yql_client = YqlClient(
            db=self.Parameters.yt_host,
            token=sdk2.Vault.data(self.owner, self.Parameters.yql_vault_token),
        )

        with self.memoize_stage.yql_query(commit_on_entrance=False):
            request = yql_client.query(
                get_models.format(
                    output_table=self.Parameters.output_table,
                    market_indexer=yt_host_to_market_indexer[self.Parameters.yt_host]
                )
            )
            request.run()
            request.get_results(wait=True)

            if not request.is_success:
                raise errors.TaskError('YQL query failed')
