get_models = '''
PRAGMA yt.QueryCacheMode = 'normal';

$script = @@
def normalize(s):
    if not s:
        return
    result = ' '.join(s.split())
    if not result:
        return
    return result
@@;

$norm = Python::normalize("(String?)->String?", $script);

$int_cast = ($y) -> {{
                    RETURN Cast($y as Int64);
                }};

$books_id = (
    SELECT hyper_id AS category_id
    FROM [home/market/production/indexer/{market_indexer}/in/categories/recent]
    WHERE 90829 IN ListFlatMap(String::SplitToList(parents, ','), $int_cast) -- main book category
);


$guru_table = (
    SELECT id AS model_id, $norm(title) AS text, category_id
    FROM [home/market/production/indexer/{market_indexer}/in/models/recent]
    WHERE current_type == 'GURU' AND parent_id == 0 AND published_on_market AND Length($norm(title)) > 0
);

$filtered_guru_table = (
    SELECT
        a.model_id as model_id,
        a.text as text
    FROM $guru_table AS a
    LEFT ONLY JOIN $books_id AS b
    USING(category_id)
);

$guru_table_msk = (
    SELECT model_id, text, 213 AS geo_id
    FROM $filtered_guru_table
);

INSERT INTO [{output_table}]
WITH TRUNCATE
SELECT *
from $guru_table_msk;
'''
