from sandbox import sdk2
import sandbox.sandboxsdk.environments as sdk_environments

from sandbox.projects.common import file_utils as fu

from sandbox.projects.MarketModelWizard import GetDocidsFromXmlSearchInputTsv


class GetTsvFromYt(sdk2.Task):
    """Download yt table as tsv"""

    class Parameters(sdk2.Task.Parameters):
        with sdk2.parameters.Group('YT parameters') as yt_parameters:
            path = sdk2.parameters.String(
                'Path with input table',
                required=True,
            )

            yt_vault_token = sdk2.parameters.String(
                'Your token name in vault',
                default='yt-token',
                required=True)

            with sdk2.parameters.RadioGroup('Yt host') as yt_host:
                yt_host.values['hahn'] = yt_host.Value(value='Hahn', default=True)
                yt_host.values['banach'] = yt_host.Value(value='Banach')

        table_columns = sdk2.parameters.List('Table columns', sdk2.parameters.String)

        end_index = sdk2.parameters.Integer('Row limit', default=None)

        with sdk2.parameters.Output:
            result_resource = sdk2.parameters.Integer('Result resource id', required=True)

    class Requirements(sdk2.Task.Requirements):
        environments = [
            sdk_environments.PipEnvironment('yandex-yt'),
            sdk_environments.PipEnvironment('yandex-yt-yson-bindings-skynet')
        ]

    def on_execute(self):
        import yt.wrapper as yt

        yt.config['token'] = sdk2.Vault.data(self.owner, self.Parameters.yt_vault_token)
        yt.config['proxy']['url'] = '{}.yt.yandex.net'.format(self.Parameters.yt_host)

        result_resource = GetDocidsFromXmlSearchInputTsv(
            self,
            'result tsv from table {path}'.format(
                path=self.Parameters.path,
            ),
            'input.tsv',
        )
        result_resource_data = sdk2.ResourceData(result_resource)

        fu.write_lines(
            result_resource_data.path,
            map(
                lambda row: '\t'.join(
                    map(lambda column_name: str(row[column_name]).replace('\t', ' '), self.Parameters.table_columns)
                ),
                yt.read_table(
                    yt.TablePath(
                        self.Parameters.path,
                        end_index=self.Parameters.end_index,
                        columns=self.Parameters.table_columns,
                    ),
                )
            )
        )

        result_resource_data.ready()

        self.Parameters.result_resource = result_resource.id
