first_part_query = '''
PRAGMA yt.QueryCacheMode = 'normal';

$add_basic_schema_script = @@
def add_basic_schema(url):
    if not url.startswith('http'):
        return 'http://' + url
    return url
@@;

$add_basic_schema_f = Python::add_basic_schema("(String?)->String", $add_basic_schema_script);

$guru_table=(
    SELECT DISTINCT id, parent_id
    FROM [home/market/production/indexer/{market_indexer}/in/models/recent]
    WHERE current_type == 'GURU' AND published_on_market
);

$url_table=(
    SELECT DISTINCT id, url
    FROM (
        SELECT model_id AS id, $add_basic_schema_f(url) as url
        FROM [home/market/production/indexer/{market_indexer}/offers/recent]
        WHERE model_id != 0
    )
);

$url_model_table=(
    SELECT DISTINCT a.id AS id, a.parent_id AS parent_id, b.url as raw_url
    FROM $guru_table AS a
    JOIN $url_table AS b ON a.id == b.id
);

INSERT INTO [{result_table}]
WITH TRUNCATE
SELECT
    raw_url AS key,
    String::JoinFromList(AsList(Cast(id as String), Cast(parent_id as String)), '\\t') AS value
FROM $url_model_table;
'''
