SELECT DISTINCT fcc.datasource_id
    , CASE
        WHEN ds.is_express = 1 THEN 'EXPRESS'
        WHEN ppp.program = 'DROPSHIP_BY_SELLER' THEN 'DSBS'
        ELSE ppp.program
    END AS program
    , fcc.cutoff_type
    , fcc.reason
    , COALESCE(s.name, d.SHOPNAME) shop_name
    , f.status
    , u.fullname manager_name
    , u.ld_login manager_login
from SHOPS_WEB.FEATURE_OPEN_CUTOFF fcc
    join shops_web.PARTNER_PLACEMENT_PROGRAM ppp on fcc.datasource_id = ppp.partner_id
    LEFT JOIN SHOPS_WEB.PARTNER_FF_SERVICE_LINK sl ON sl.partner_id = fcc.datasource_id
    LEFT JOIN SHOPS_WEB.DELIVERY_SERVICES ds ON ds.id = sl.service_id
    LEFT JOIN shops_web.V_DATASOURCE d ON d.id = fcc.datasource_id
    LEFT JOIN SHOPS_WEB.SUPPLIER s ON s.id = fcc.datasource_id
    JOIN shops_web.partner p ON p.id = fcc.datasource_id
    JOIN SHOPS_WEB.FEATURE f ON f.datasource_id = fcc.datasource_id
    LEFT JOIN shops_web.user_roles u ON u.id = p.manager_id
where from_time > timestamp '{} 09:00:00'
    AND from_time < timestamp '{} 09:00:00'
    AND ppp.program = 'DROPSHIP_BY_SELLER'
    AND cutoff_type NOT IN (100000, 1003, 1004, 1015, 1001, 1016, 1006, 111, 1017, 1018, 1023)
    AND fcc.feature_type = 1015
    AND f.feature_type = 1015
