# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

from sandbox import sdk2
from sandbox.sandboxsdk import environments


class DbsFastPostcheck(sdk2.Task):
    """Task generates tickets for checking the DBS that are connected under the accelerated program."""

    class Requirements(sdk2.Requirements):
        ram = 1024
        cores = 1
        disk_space = 128

        environments = [
            environments.PipEnvironment('yql'),
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('startrek_client', version='2.5',
                                        custom_parameters=['--upgrade-strategy', 'only-if-needed'])
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        description = 'Task generates tickets for checking the DBS' +\
            'that are connected under the accelerated program.'
        max_restarts = 3
        dump_disk_usage = False
        fail_on_any_error = True

        st_token = sdk2.parameters.YavSecret('OAuth ST token',
                                             required=True)
        yt_token = sdk2.parameters.YavSecret('OAuth YQL token',
                                             required=True)

    def on_execute(self):
        from sandbox.projects.MarketQC.dbs_fast_postcheck.lib import run

        run(yt_token=self.Parameters.yt_token.data()[self.Parameters.yt_token.default_key],
            st_token=self.Parameters.st_token.data()[self.Parameters.st_token.default_key])
