# -*- coding: utf-8 -*-

from collections import namedtuple

from sandbox.projects.MarketQC.dbs_fast_postcheck.lib.description import DESCRIPTION
from sandbox.projects.MarketQC.dbs_fast_postcheck.lib.query import FAST_DBS_ACTIVATED

STARTREK_URL = 'https://st-api.yandex-team.ru/v2'


def execute_query(query, token):
    from yql.api.v1.client import YqlClient

    client = YqlClient(token=token)
    request = client.query(query)
    request.run()

    for result in request.get_results():
        record = namedtuple('Record', result.column_names)
        for row in result.get_iterator():
            yield record(*row)


def create_issue(shop_data, token=None):
    from startrek_client import Startrek

    client = Startrek(useragent='market-quality-control',
                      base_url=STARTREK_URL,
                      token=token)

    summary = 'Проверка магазина {0} ({1}) после включения без модерации'.format(
        shop_data.shop_name, shop_data.shop_id)

    phone = '((tel:{tel} {tel}))'.format(tel=shop_data.contacts.phone.replace(' ', '-')) \
        if shop_data.contacts is not None and shop_data.contacts.phone != '' else ''
    premod_ticket = 'https://abo.market.yandex-team.ru/premod/ticket/%i' % shop_data.last_donor_ticket_id \
        if shop_data.last_donor_ticket_id is not None else ''
    alert = '\n**!!Магазин-донор имеет активное отключение за неприемлемое качество.!!**' \
        if shop_data.donor_no_placement_reason is not None else ''
    active_reason = '* Причина активного отключения: %s' % shop_data.donor_no_placement_reason \
        if shop_data.donor_no_placement_reason is not None else ''

    description = DESCRIPTION.format(shop_id=shop_data.shop_id,
                                     business_id=shop_data.business_id,
                                     region=shop_data.region_ru_name,
                                     manager=shop_data.manager_fullname,
                                     order_processing_method=shop_data.order_processing_method,
                                     reg_date=shop_data.registration_date,
                                     activation_date=shop_data.activated_date,
                                     phone=phone,
                                     campaign_id=shop_data.campaign_id,
                                     donor_shop_id=shop_data.donor_partner_id,
                                     premod_ticket=premod_ticket,
                                     alert=alert,
                                     active_reason=active_reason)

    client.issues.create(
        queue='DBSCHECK',
        summary=summary,
        type={'name': 'Задача'},
        description=description,
        components='DBS: постмодерация партнеров',
        idMagazina=shop_data.shop_id
    )

    description += '\n\nСоздать гипотезу на магазин: https://abo.market.yandex-team.ru/shopdata/check?shopId=%i' % shop_data.shop_id
    description += '\nСводка партнёра: https://abo.market.yandex-team.ru/partner/%i' % shop_data.shop_id

    client.issues.create(
        queue='MARKETCL',
        summary=summary,
        type={'name': 'Задача'},
        description=description,
        components='Проверка на клоновость',
        idMagazina=shop_data.shop_id
    )


def run(yt_token, st_token):
    for shop_data in execute_query(FAST_DBS_ACTIVATED, token=yt_token):
        create_issue(shop_data, token=st_token)
