# -*- coding: utf-8 -*-

FAST_DBS_ACTIVATED = """
PRAGMA AnsiInForEmptyOrNullableItemsCollections;
$today = CAST(CurrentUtcDate() AS String);
$yesterday = CAST(CurrentUtcDate() - DateTime::IntervalFromDays(1) AS String);

$premod_tickets = SELECT DISTINCT CAST(shop_id AS Int64)
    FROM hahn.`//home/market/production/mstat/dictionaries/premod_ticket/latest`;

$DSBS = SELECT DISTINCT shop_id,
    activated_date,
    registration_date
FROM (
    SELECT DISTINCT shop_id,
        SUBSTRING(MIN(time), 0, 10) AS activated_date
    FROM hahn.RANGE(`//home/market/production/mbi/barc/entity_history`, '2021-01-01', $today)
    WHERE entity_name = 'partner-placement-program'
        AND Xml::XPathGetString(Xml::Root(Xml::Parse(xml_snapshot)), '/partnerPlacementProgram/@program') = 'DROPSHIP_BY_SELLER'
        AND Xml::XPathGetString(Xml::Root(Xml::Parse(xml_snapshot)), '/partnerPlacementProgram/@everActivated') = 'true'
    GROUP BY datasource_id AS shop_id
) AS a
LEFT JOIN (
    SELECT DISTINCT datasource_id,
        SUBSTRING(MIN(time), 0, 10) AS registration_date
    FROM hahn.RANGE(`//home/market/production/mbi/barc/entity_history`, '2021-01-01', $today) AS h
    JOIN hahn.`//home/market/production/mstat/dictionaries/mbi/partner_program_type/latest` AS p ON h.datasource_id = p.partner_id
    WHERE program='DROPSHIP_BY_SELLER'
        AND entity_name = 'datasource'
        AND edit_type = 1
    GROUP BY h.datasource_id
) AS r ON a.shop_id = r.datasource_id
WHERE activated_date = $yesterday;

SELECT d.*,
    shop_name,
    manager_fullname,
    region_ru_name,
    campaign_id,
    CASE WHEN business_owner IS NOT NULL THEN business_owner
        WHEN business_admin IS NOT NULL THEN business_admin
        WHEN shop_admin IS NOT NULL THEN shop_admin
        ELSE NULL
    END AS contacts,
    CAST(business_id AS Int64) AS business_id,
    displayed_offers,
    hidden_offers,
    order_processing_method,
    donor_partner_id,
    last_donor_ticket_id,
    donor_no_placement_reason
FROM $DSBS AS d
JOIN hahn.`//home/market/production/mstat/dictionaries/analyst_shops_dict/latest` AS a ON d.shop_id = a.shop_id
LEFT JOIN (
    SELECT shop_id,
        ListHead(ListFilter(contacts, ($i) -> { return $i.role == 'BUSINESS_OWNER' })) AS business_owner,
        ListHead(ListFilter(contacts, ($i) -> { return $i.role == 'BUSINESS_ADMIN' })) AS business_admin,
        ListHead(ListFilter(contacts, ($i) -> { return $i.role == 'SHOP_ADMIN' })) AS shop_admin
    FROM (
        SELECT shop_id,
            AGGREGATE_LIST(AsStruct(email AS email, name AS name, phone AS phone, role AS role)) AS contacts
        FROM hahn.`//home/market/production/mstat/dictionaries/shop_crm_contacts/latest`
        GROUP BY shop_id
    )
) AS c ON d.shop_id = c.shop_id
LEFT JOIN hahn.`//home/market/production/mstat/dictionaries/partner_types/latest` AS t ON d.shop_id = t.id
LEFT JOIN (
    SELECT shop_id,
        COUNT_IF(status.`result` IN (1, 2)) AS displayed_offers,
        COUNT_IF(status.`result` NOT IN (1, 2)) AS hidden_offers
    FROM hahn.`//home/market/production/indexer/datacamp/united/service_offers`
    WHERE status.united_catalog.flag = True
    GROUP BY shop_id
) AS s ON d.shop_id = s.shop_id
LEFT JOIN (
    SELECT entity_id,
        CASE WHEN num_value IS NOT NULL THEN 'ЛК'
            ELSE 'API'
        END AS order_processing_method
    FROM hahn.`//home/market/production/mstat/dictionaries/shop_param_value/latest`
    WHERE param_type_id = 150
) AS p ON d.shop_id = p.entity_id
JOIN hahn.`//home/market/production/mstat/dictionaries/mbi/partner_links/latest` AS l ON d.shop_id = l.child_partner_id
LEFT JOIN (
    SELECT shop_id,
        MAX_BY(id, SUBSTRING(creation_time, 0, 10)) AS last_donor_ticket_id
    FROM hahn.`//home/market/production/mstat/dictionaries/premod_ticket/latest`
    GROUP BY CAST(shop_id AS Int64) AS shop_id
) AS pt ON l.donor_partner_id = pt.shop_id
LEFT JOIN (
    SELECT DISTINCT shop_id,
        CASE
            WHEN reason_id = 5 THEN 'Б.у. товары'
            WHEN reason_id = 7 THEN 'Оптовый магазин'
            WHEN reason_id = 8 THEN 'Магазин не работает с физ.лицами'
            WHEN reason_id = 9 THEN 'Оплата возможна только физическому лицу'
            WHEN reason_id = 10 THEN 'Нет точки продаж (у регионального клона, либо у оффлайн-магазина)'
            WHEN reason_id = 11 THEN 'Юридическое лицо приостановило свою деятельность'
            WHEN reason_id = 12 THEN 'Дропшиппер'
            WHEN reason_id = 14 THEN 'Развод'
            WHEN reason_id = 15 THEN 'Совокупность данных по итогам размещения (ошибки, частые отключения)'
            WHEN reason_id = 16 THEN 'Смена ассортимента'
            WHEN reason_id = 17 THEN 'Отказ из-за полученных жалоб на магазин'
            WHEN reason_id = 18 THEN 'Систематическое нарушение требований законодательства (выгрузка запрещенных товаров)'
            WHEN reason_id = 20 THEN 'Причина для технических проблем'
            WHEN reason_id = 21 THEN 'Магазин не предоставил: ответ, документы и тп.'
            WHEN reason_id = 55 THEN 'Несоответствие реквизитов в чеках и личном кабинете'
            WHEN reason_id = 56 THEN 'Клоновость - без кластера.'
            WHEN reason_id = 57 THEN 'Недостоверные данные о номере ОГРН'
            WHEN reason_id = 58 THEN 'Проблемы выявленные при КЗ (Отказ в передаче товара и тп)'
            WHEN reason_id = 92 THEN 'Лекарственные препараты с доставкой'
            WHEN reason_id = 93 THEN 'Контрафакт'
            WHEN reason_id = 94 THEN 'Cайт находится в стадии разработки или наполнения контентом'
            WHEN reason_id = 95 THEN 'Приглашение в офис'
            WHEN reason_id = 128 THEN 'Пункт 15 (без согласования не использовать)'
            WHEN reason_id = 161 THEN 'Услуги являются основным ассортиментом магазина'
            WHEN reason_id = 165 THEN 'Алкоголь на картинке'
            WHEN reason_id = 166 THEN 'Магазин продает табачные изделия'
            WHEN reason_id = 167 THEN 'Магазин продает оружие'
            WHEN reason_id = 200 THEN 'Магазин отказывает в возврате товара надлежащего качества'
            WHEN reason_id = 201 THEN 'Магазин принимает возвраты только с доставкой за счёт покупателя'
            WHEN reason_id = 233 THEN 'Магазин продает товары ритуального назначения'
            WHEN reason_id = 234 THEN 'Ювелирные изделия с доставкой'
            WHEN reason_id = 235 THEN 'Приглашение на Skype-встречу'
            WHEN reason_id = 236 THEN 'Спекуляция на теме с коронавирусом'
            WHEN reason_id = 237 THEN 'Магазин не выполнил доставку'
            WHEN reason_id = 238 THEN 'Интегратор'
            WHEN reason_id = 239 THEN 'Представленный сайт не является продавцом товаров'
            WHEN reason_id = 240 THEN 'Отказ в выдаче контрольно кассовых документов'
            WHEN reason_id = 241 THEN 'Сайт не работает (причина ТОЛЬКО для Турбоапп магазинов)'
            WHEN reason_id = 242 THEN 'Продажа животных и птиц'
            WHEN reason_id = 243 THEN 'Магазин из Украины'
            WHEN reason_id = 244 THEN 'Прекурсоры и аналогичные товары'
            WHEN reason_id = 245 THEN 'Мошенничество (причина ТОЛЬКО для Турбоапп магазинов)'
            WHEN reason_id = 246 THEN 'Магазин не доставляет товар в РФ, РБ или РК (ТОЛЬКО для Турбоапп магазинов)'
            WHEN reason_id = 280 THEN 'Реклама услуги или товара запрещена или ограничена законодательством Российской Федерации (ДЛЯ ТУРБО)'
            WHEN reason_id = 281 THEN 'Отключение за отсутствие финальных статусов'
            WHEN reason_id = 282 THEN 'По запросу магазина'
            WHEN reason_id = 283 THEN 'Клон выключенного за неприемлемое качество'
            WHEN reason_id = 284 THEN 'Клон'
            WHEN reason_id = 285 THEN 'По запросу менеджера'
            WHEN reason_id = 286 THEN 'Проблемы с индексом качества'
            WHEN reason_id = 287 THEN 'Приостановления операций по счетам'
            WHEN reason_id = 288 THEN 'Предоставил фиктивные документы'
            WHEN reason_id = 289 THEN 'Неверно указаны контакты для возврата'
            WHEN reason_id = 290 THEN 'Мошенник'
            WHEN reason_id = 291 THEN 'Товары недопустимые к продаже на площадке'
            WHEN reason_id = 292 THEN 'Проблемы с ценами (Цена выше медианы/не имеет отношение к товару)'
            WHEN reason_id = 293 THEN 'Вовремя не подтвердил заказ (экспресс)'
            WHEN reason_id = 294 THEN 'Проблемы с API'
            WHEN reason_id = 295 THEN 'Некорректное название'
            WHEN reason_id = 296 THEN 'Другое (без объяснения причин)'
            WHEN reason_id = 297 THEN 'Фрод со статусом "Покупатель передумал" (OCV)'
            WHEN reason_id = 298 THEN 'Фрод со статусом "DELIVERED"'
            ELSE 'unknown'
        END AS donor_no_placement_reason
    FROM hahn.`//home/market/production/mstat/dictionaries/no_placement_record/latest`
    WHERE closed = False
) AS np ON l.donor_partner_id = np.shop_id
WHERE d.shop_id NOT IN $premod_tickets;
"""
