# -*- coding: utf-8 -*-
from json import dumps
from random import choice
from requests import get, patch

RULES_COUNT = 5
STARTREK_URL = 'https://st-api.yandex-team.ru/v2'


def get_staff_absences(token):
    url = 'https://staff.yandex-team.ru/gap-api/api/export_gaps?field=person_login&field=workflow'
    headers = {'Authorization': 'OAuth {}'.format(token), 'content-type': 'application/json',
               'Accept-Charset': 'UTF-8'}
    response = get(url, headers=headers).json()

    return response['persons'].keys()


def get_available_assignees(grid, token):
    url = 'https://wiki-api.yandex-team.ru/_api/frontend/{}/.grid'.format(grid)
    headers = {'Authorization': 'OAuth {}'.format(token), 'content-type': 'application/json',
               'Accept-Charset': 'UTF-8'}
    response = get(url, headers=headers, timeout=1200).json()
    table = response['data']['rows']

    try:
        return [row[0]['raw'][0] for row in table if len(row[0]['raw']) > 0]
    except:
        return []


def collect_issues(filter, token=None):
    from startrek_client import Startrek
    client = Startrek(
        useragent='market-quality-control', base_url=STARTREK_URL, token=token
    )
    return client.issues.find(filter, perPage=100)


ASSESSORS_GRID = [
    'users/hitinap/ispolniteli---gruppa-jekspertnyx-proverok/grid-2021-11-09t122756',  # 1
    'users/hitinap/ispolniteli---gruppa-jekspertnyx-proverok/grid-2021-11-09t123221',  # 2
    'users/hitinap/ispolniteli---gruppa-jekspertnyx-proverok/grid-2021-11-09t123444',  # 3
    'users/hitinap/ispolniteli---gruppa-jekspertnyx-proverok/grid-2021-11-09t123637',  # 4
    'users/hitinap/ispolniteli---gruppa-jekspertnyx-proverok/grid-2021-11-09t123953',  # 5
    'users/hitinap/ispolniteli---gruppa-jekspertnyx-proverok/grid-2021-12-28t105612',  # 6
    'users/hitinap/ispolniteli---gruppa-jekspertnyx-proverok/grid-2022-05-28t193330',  # 7
    'users/hitinap/ispolniteli---gruppa-jekspertnyx-proverok/grid-2022-05-28t193419',  # 8
]

STARTREK_FILTER = [
    '(Components: 88508 OR Components: 88635 OR Components: 102678) '  # 1
    + 'Assignee: empty() Resolution: empty() Queue: BQ Created: < today() - "4h"',
    'Queue: BQ Components: 82199 Assignee: empty() Resolution: empty()',  # 2
    'Queue: BQ Components: 108844 Assignee: empty() Resolution: empty()',  # 3
    '(Components: 102679 OR Components: 97834 OR Components: 82202 OR Components: 103512 OR Components: 109890) '  # 4
    + 'Assignee: empty() Resolution: empty() Queue: BQ Created: < today() - "1h"',
    'Components: 107028 Assignee: empty() Resolution: empty() Queue: BQ Created: < today() - "2h"',  # 5
    'Components: 29649 AND Queue: MARKETQUALITY AND Assignee: empty() '  # 6
    + 'AND Resolution: empty() AND Created: < today() - "1h"',
    'Components: 83871 AND Queue: MARKETQUALITY AND Assignee: empty() '  # 7
    + 'AND Resolution: empty() AND Created: < today() - "1h"',
    'Components: 102402 AND Queue: MARKETQUALITY AND Assignee: empty() '  # 8
    + 'AND Resolution: empty() AND Created: < today() - "1h"',
]


def pick_assignee(assignees):
    if len(set(assignees.values())) > 1:
        val = min(assignees.values())
        return choice([k for k, v in assignees.items() if v == val])
    else:
        return choice(list(assignees))


def update_issue(issue, login, token=None):
    url = 'https://st-api.yandex-team.ru/v2/issues/{}'.format(issue.key)
    headers = {'Authorization': 'OAuth {}'.format(token)}
    patch(url, data=dumps({'assignee': login}, ensure_ascii=False).encode('utf-8'),
          headers=headers)


def run_selection(st_token):
    absences = get_staff_absences(token=st_token)
    for i in range(RULES_COUNT):
        assignees = {
            login: 0 for login in get_available_assignees(ASSESSORS_GRID[i], st_token)
            if login not in absences
        }
        if len(assignees) > 0:
            for issue in collect_issues(STARTREK_FILTER[i], st_token):
                assignee = pick_assignee(assignees)
                update_issue(issue, assignee, token=st_token)
                assignees[assignee] += 1
