# -*- coding: utf-8 -*-
from __future__ import absolute_import, division, print_function, unicode_literals

from sandbox import sdk2
from sandbox.sandboxsdk import environments


class OrdersWithoutFinalStatus(sdk2.Task):

    class Requirements(sdk2.Requirements):
        ram = 3144
        cores = 3
        disk_space = 2048

        environments = [
            environments.PipEnvironment('yql'),
            environments.PipEnvironment('pandas'),
            environments.PipEnvironment('yandex-yt'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet'),
            environments.PipEnvironment('startrek_client', version='2.5',
                                        custom_parameters=['--upgrade-strategy', 'only-if-needed'])
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Task.Parameters):
        description = 'Daily unloading of orders without final status'
        max_restarts = 2
        kill_timeout = 5 * 3600
        fail_on_any_error = True
        dump_disk_usage = False

        st_token = sdk2.parameters.YavSecret('OAuth ST token',
                                             required=True)
        yt_token = sdk2.parameters.YavSecret('OAuth YQL token',
                                             required=True)

        with sdk2.parameters.Group('Database parameters') as database_parameters:
            host = sdk2.parameters.String('Host', default='man-i9jmlo2jx3thalwg.db.yandex.net',
                                          required=True)
            port = sdk2.parameters.Integer('Port', default=6432, required=True)
            dbname = sdk2.parameters.String('Database', required=True)
            user = sdk2.parameters.String('User', required=True)
            password = sdk2.parameters.YavSecret('Password', required=True)
            sslmode = sdk2.parameters.String('sslmode', default='require',
                                             required=True)

    def on_execute(self):
        from sandbox.projects.MarketQC.orders_without_final_status.lib import run

        st_token = self.Parameters.st_token.data()[self.Parameters.st_token.default_key]
        yt_token = self.Parameters.yt_token.data()[self.Parameters.yt_token.default_key]

        config = dict(host=self.Parameters.host,
                      port=self.Parameters.port,
                      dbname=self.Parameters.dbname,
                      user=self.Parameters.user,
                      password=self.Parameters.password.data()[self.Parameters.password.default_key],
                      sslmode=self.Parameters.sslmode)

        run(db_config=config, st_token=st_token, yt_token=yt_token)
