CHECKOUTER_ORDERS = """
SELECT DISTINCT ON (o.id)
    o.shop_id,
    o.id order_id
FROM orders o
WHERE o.fake = FALSE AND o.preorder = FALSE
    AND o.rgb = 4
    AND o.id = ANY('{{{0}}}'::int[])
"""

SHOP_CONTACTS = """
pragma AnsiInForEmptyOrNullableItemsCollections;

$summary_orders = select shop_id,
        count(order_id) as order_cnt
    from hahn.`//home/market/production/mstat/analyst/market-orders-dict/1d/latest`
    group by shop_id;

select o.shop_id as shop_id,
    order_cnt,
    a.campaign_id as campaign_id,
    a.shop_name as shop_name,
    case when business_owner is not Null then business_owner
        when business_admin is not Null then business_admin
        when shop_admin is not Null then shop_admin
        else Null
    end as contacts,
    manager_fullname,
    business_id
from (
    select shop_id,
        ListHead(ListFilter(contacts, ($i) -> {{ return $i.role == 'BUSINESS_OWNER' }})) as business_owner,
        ListHead(ListFilter(contacts, ($i) -> {{ return $i.role == 'BUSINESS_ADMIN' }})) as business_admin,
        ListHead(ListFilter(contacts, ($i) -> {{ return $i.role == 'SHOP_ADMIN' }})) as shop_admin
    from (
        select shop_id,
            AGGREGATE_LIST(AsStruct(email as email, name as name, phone as phone, role as role)) as contacts
        from hahn.`//home/market/production/mstat/dictionaries/shop_crm_contacts/latest`
        group by
            shop_id
    )
) as c
inner join $summary_orders as o on o.shop_id = c.shop_id
left join hahn.`//home/market/production/mstat/dictionaries/analyst_shops_dict/latest` as a on a.shop_id = c.shop_id
left join hahn.`//home/market/production/mstat/dictionaries/mbi/partner_biz_snapshot/latest` as s on a.shop_id = s.id
where o.shop_id in ({0});
"""
