# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import environments
from sandbox import sdk2


class YtNodeCleaner(sdk2.Task):
    """Sandbox задача которая удаляет все файлы и таблицы в указанной директории кластера, последнее обновление которых было больше,
    чем указанный TTL, а так-же все пустые вложенные директории.

    Параметры задачи:

    * `token` - OAuth токен, который будет использован для аутентификации.
    * `proxy` - Кластер YT.
    * `root` - Корневая директория для очистки.
    * `ttl` - Время жизни узла в часах.
    * `exclude` - Список узлов, которые нужно исключить из очистки.
    """

    class Parameters(sdk2.Task.Parameters):
        description = sdk2.parameters.String('', required=False)
        max_restarts = 2
        kill_timeout = 25 * 60
        dump_disk_usage = False
        fail_on_any_error = True

        token = sdk2.parameters.YavSecret('OAuth YT token', required=True)
        proxy = sdk2.parameters.String('YT cluster', default='hahn', required=True)
        root = sdk2.parameters.String('Root directory', required=True)
        ttl = sdk2.parameters.Integer('TTL', default=12)
        exclude = sdk2.parameters.List('Exclude nodes')

        tags = ['YT', 'DataManager']

    class Requirements(sdk2.Requirements):
        ram = 1024
        cores = 1
        disk_space = 100

        environments = [
            environments.PipEnvironment('yandex-yt')
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    def on_execute(self):
        from sandbox.projects.MarketQC.yt_data_manager.cleaner.lib import Cleaner

        token = self.Parameters.token.data()
        token = token[self.Parameters.token.default_key]

        cleaner = Cleaner(token=token, proxy=self.Parameters.proxy)
        cleaner.run_cleaner(root=self.Parameters.root,
                            ttl=self.Parameters.ttl,
                            exclude=self.Parameters.exclude)
